/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyRulerAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public final class RulerJumpToMemoryAction
extends AbstractDisassemblyRulerAction {
    private static final String MEMORY_VIEW_ID = "org.eclipse.debug.ui.MemoryView";

    public RulerJumpToMemoryAction(IDisassemblyPart disassemblyPart, IVerticalRulerInfo rulerInfo) {
        super(disassemblyPart, rulerInfo);
        this.setText(DisassemblyMessages.Disassembly_action_JumpToMemory_label);
        this.setToolTipText(DisassemblyMessages.Disassembly_action_JumpToMemory_tooltip);
    }

    @Override
    public void run() {
        if (this.getRulerInfo() == null || this.getDisassemblyPart() == null) {
            this.reportException(new Exception("The current selection is invalid."));
            return;
        }
        IAddress address = this.getAddress();
        if (address == null) {
            this.reportException(new Exception("Failed to retrieve memory address."));
            return;
        }
        IWorkbenchPartSite site = this.getDisassemblyPart().getSite();
        if (site == null) {
            this.reportException(new Exception("No workbench site available. Disassembly view not initialized?"));
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            this.reportException(new Exception("No workbench page available. Disassembly view not initialized?"));
            return;
        }
        IViewPart viewPart = page.findView(MEMORY_VIEW_ID);
        if (viewPart != null) {
            page.activate((IWorkbenchPart)viewPart);
        } else {
            try {
                viewPart = page.showView(MEMORY_VIEW_ID);
            }
            catch (PartInitException e) {
                this.reportException((Exception)((Object)e));
                return;
            }
        }
        if (!(viewPart instanceof IMemoryRenderingSite)) {
            this.reportException(new Exception("Failed to open memory view."));
            return;
        }
        this.addMemoryBlock((IMemoryRenderingSite)viewPart, address.toHexAddressString());
    }

    private void addMemoryBlock(IMemoryRenderingSite memoryView, String address) {
        try {
            IAdaptable debugContext = DebugUITools.getPartDebugContext((IWorkbenchPartSite)this.getDisassemblyPart().getSite());
            IMemoryBlockRetrievalExtension memRetrieval = (IMemoryBlockRetrievalExtension)MemoryViewUtil.getMemoryBlockRetrieval((Object)debugContext);
            IMemoryBlockExtension memBlock = memRetrieval.getExtendedMemoryBlock(address, (Object)debugContext);
            if (memBlock == null) {
                throw new Exception("Failed to retrieve memory block.");
            }
            IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(memArray);
            IMemoryRenderingType renderingType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType((IMemoryBlock)memBlock);
            IMemoryRendering rendering = renderingType.createRendering();
            IMemoryRenderingContainer container = memoryView.getContainer("org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            rendering.init(container, (IMemoryBlock)memBlock);
            container.addMemoryRendering(rendering);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    private IAddress getAddress() {
        IRegion region;
        int lastLine = this.getRulerInfo().getLineOfLastMouseButtonActivity();
        if (lastLine < 0) {
            return null;
        }
        ISelectionProvider provider = this.getDisassemblyPart().getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        IDocument document = this.getDisassemblyPart().getTextViewer().getDocument();
        if (document == null) {
            return null;
        }
        try {
            region = document.getLineInformation(lastLine);
        }
        catch (BadLocationException e) {
            return null;
        }
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        DisassemblySelection selection = new DisassemblySelection((ITextSelection)textSelection, this.getDisassemblyPart());
        return selection.getStartAddress();
    }

    private void reportException(Exception e) {
        Status status = new Status(4, "org.eclipse.cdt.debug.ui", "Error on jump to memory: ", (Throwable)e);
        ErrorDialog.openError((Shell)this.getDisassemblyPart().getSite().getShell(), (String)DisassemblyMessages.Disassembly_action_JumpToMemory_errorTitle, (String)DisassemblyMessages.Disassembly_action_JumpToMemory_errorMessage, (IStatus)status);
        CDebugUIPlugin.log((IStatus)status);
    }
}

