/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.navigator.AbstractCNavigatorActionGroup;
import org.eclipse.cdt.internal.ui.navigator.OpenCElementAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;

public class CNavigatorOpenEditorActionGroup
extends AbstractCNavigatorActionGroup {
    private OpenFileAction fOpenFileAction;

    public CNavigatorOpenEditorActionGroup(IViewPart viewPart) {
        super(viewPart);
    }

    @Override
    protected void makeActions() {
        this.fOpenFileAction = new OpenCElementAction(this.getViewPart().getSite().getPage());
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection selection = SelectionConverter.convertSelectionToResources((ISelection)celements);
        this.fOpenFileAction.selectionChanged(celements);
        if (this.fOpenFileAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.fOpenFileAction);
            this.fillOpenWithMenu(menu, selection);
        }
        this.addNewWindowAction(menu, selection);
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager(CViewMessages.OpenWithMenu_label, "group.openWith");
        submenu.add((IContributionItem)new OpenWithMenu(this.getViewPart().getSite().getPage(), (IAdaptable)((IFile)element)));
        menu.insertAfter("group.openWith", (IContributionItem)submenu);
    }

    private void addNewWindowAction(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof ICElement) {
            element = ((ICElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.getViewPart().getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
    }

    @Override
    public void updateActionBars() {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        this.fOpenFileAction.selectionChanged(celements);
    }

    IAction getOpenAction() {
        return this.fOpenFileAction;
    }
}

