/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class CFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final Deque<WorkItem> fWorkItems = new ArrayDeque<WorkItem>();

    public void format() {
        super.format();
        WorkItem workItem = this.fWorkItems.getFirst();
        IDocument document = workItem.document;
        TypedPosition partition = workItem.partition;
        if (document == null || partition == null) {
            return;
        }
        Map preferences = this.getPreferences();
        try {
            TextEdit edit = CodeFormatterUtil.format(8, document.get(), partition.getOffset(), partition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document), preferences);
            if (edit != null) {
                edit.apply(document);
            }
        }
        catch (MalformedTreeException e) {
            CUIPlugin.log(e);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        TypedPosition partition = (TypedPosition)context.getProperty((Object)"formatting.context.partition");
        IDocument document = (IDocument)context.getProperty((Object)"formatting.context.medium");
        this.fWorkItems.addLast(new WorkItem(document, partition));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fWorkItems.clear();
    }

    private static class WorkItem {
        final IDocument document;
        final TypedPosition partition;

        WorkItem(IDocument document, TypedPosition partition) {
            this.document = document;
            this.partition = partition;
        }
    }
}

