/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.RequestTemplate;
import org.eclipse.epp.internal.mpc.core.util.UserAgentUtil;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="org.eclipse.epp.mpc.core.transport.http", service={HttpClientTransport.class, ITransport.class})
public class HttpClientTransport
implements ITransport {
    public static final String USER_AGENT;
    public static final String USER_AGENT_PROPERTY;
    public static final int DEFAULT_READ_TIMEOUT;
    public static final int DEFAULT_CONNECT_TIMEOUT;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    public static final String READ_TIMEOUT_PROPERTY;
    public static final String CONNECT_TIMEOUT_PROPERTY;
    public static final String CONNECTION_REQUEST_TIMEOUT_PROPERTY;
    private HttpClientService clientService;

    static {
        USER_AGENT_PROPERTY = HttpClientTransport.class.getPackage().getName() + ".userAgent";
        DEFAULT_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        DEFAULT_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
        DEFAULT_CONNECTION_REQUEST_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        READ_TIMEOUT_PROPERTY = HttpClientTransport.class.getPackage().getName() + ".readTimeout";
        CONNECT_TIMEOUT_PROPERTY = HttpClientTransport.class.getPackage().getName() + ".connectTimeout";
        CONNECTION_REQUEST_TIMEOUT_PROPERTY = HttpClientTransport.class.getPackage().getName() + ".connectionRequestTimeout";
        USER_AGENT = UserAgentUtil.computeUserAgent();
    }

    public HttpClient getClient() {
        return this.clientService.getClient();
    }

    @Reference
    public void bindHttpClientService(HttpClientService service) {
        this.clientService = service;
    }

    protected HttpRequest configureRequest(HttpUriRequest request) {
        return this.clientService.configureRequest((ClassicHttpRequest)request);
    }

    @Override
    public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, ServiceUnavailableException, CoreException {
        try {
            return this.createStreamingRequest().execute(this.clientService, location);
        }
        catch (HttpResponseException e) {
            int statusCode = e.getStatusCode();
            switch (statusCode) {
                case 404: {
                    FileNotFoundException fnfe = new FileNotFoundException(e.getMessage());
                    fnfe.initCause(e);
                    throw fnfe;
                }
                case 503: {
                    throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
                }
            }
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
        catch (IOException e) {
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
    }

    protected RequestTemplate<InputStream> createStreamingRequest() {
        return new RequestTemplate<InputStream>(){

            protected HttpUriRequest createRequest(URI uri) {
                return new HttpGet(uri);
            }

            @Override
            protected InputStream handleResponse(ClassicHttpResponse response) throws ClientProtocolException, IOException {
                HttpEntity entity = response.getEntity();
                byte[] contentBytes = EntityUtils.toByteArray((HttpEntity)entity);
                return new ByteArrayInputStream(contentBytes);
            }

            @Override
            protected InputStream handleResponseStream(InputStream content, Charset charset) throws IOException {
                return content;
            }

            @Override
            protected InputStream handleEmptyResponse() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }
}

