/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class ProblemBindingChecker
extends AbstractIndexAstChecker {
    public static String ERR_ID_OverloadProblem = "org.eclipse.cdt.codan.internal.checkers.OverloadProblem";
    public static String ERR_ID_AmbiguousProblem = "org.eclipse.cdt.codan.internal.checkers.AmbiguousProblem";
    public static String ERR_ID_CircularReferenceProblem = "org.eclipse.cdt.codan.internal.checkers.CircularReferenceProblem";
    public static String ERR_ID_RedeclarationProblem = "org.eclipse.cdt.codan.internal.checkers.RedeclarationProblem";
    public static String ERR_ID_RedefinitionProblem = "org.eclipse.cdt.codan.internal.checkers.RedefinitionProblem";
    public static String ERR_ID_MemberDeclarationNotFoundProblem = "org.eclipse.cdt.codan.internal.checkers.MemberDeclarationNotFoundProblem";
    public static String ERR_ID_LabelStatementNotFoundProblem = "org.eclipse.cdt.codan.internal.checkers.LabelStatementNotFoundProblem";
    public static String ERR_ID_InvalidTemplateArgumentsProblem = "org.eclipse.cdt.codan.internal.checkers.InvalidTemplateArgumentsProblem";
    public static String ERR_ID_TypeResolutionProblem = "org.eclipse.cdt.codan.internal.checkers.TypeResolutionProblem";
    public static String ERR_ID_FunctionResolutionProblem = "org.eclipse.cdt.codan.internal.checkers.FunctionResolutionProblem";
    public static String ERR_ID_InvalidArguments = "org.eclipse.cdt.codan.internal.checkers.InvalidArguments";
    public static String ERR_ID_MethodResolutionProblem = "org.eclipse.cdt.codan.internal.checkers.MethodResolutionProblem";
    public static String ERR_ID_FieldResolutionProblem = "org.eclipse.cdt.codan.internal.checkers.FieldResolutionProblem";
    public static String ERR_ID_VariableResolutionProblem = "org.eclipse.cdt.codan.internal.checkers.VariableResolutionProblem";
    public static String ERR_ID_Candidates = "org.eclipse.cdt.codan.internal.checkers.Candidates";
    public static String ERR_ID_StructuredBindingDeclarationProblem = "org.eclipse.cdt.codan.internal.checkers.StructuredBindingDeclarationProblem";
    public static String ERR_ID_TemplateInstantiationProblem = "org.eclipse.cdt.codan.internal.checkers.TemplateInstantiationProblem";

    public boolean runInEditor() {
        return true;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.getLaunchModePreference((IProblem)problem).enableInLaunchModes(new CheckerLaunchMode[]{CheckerLaunchMode.RUN_AS_YOU_TYPE, CheckerLaunchMode.RUN_ON_DEMAND});
    }

    public void processAst(IASTTranslationUnit ast) {
        try {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitNames = true;
                    this.shouldVisitImplicitNames = true;
                }

                public int visit(IASTName name) {
                    block27: {
                        IProblemBinding problemBinding;
                        String contextFlagsString;
                        IASTNode parentNode;
                        block41: {
                            block40: {
                                int id;
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block33: {
                                                            block32: {
                                                                block31: {
                                                                    IASTName problemNode;
                                                                    String typeString;
                                                                    block30: {
                                                                        block29: {
                                                                            IBinding binding;
                                                                            block28: {
                                                                                binding = name.resolveBinding();
                                                                                if (!(binding instanceof IProblemBinding)) break block27;
                                                                                parentNode = name.getParent();
                                                                                if (!(parentNode instanceof ICPPASTQualifiedName) || !(((ICPPASTQualifiedName)parentNode).resolveBinding() instanceof IProblemBinding)) break block28;
                                                                                return 3;
                                                                            }
                                                                            contextFlagsString = ProblemBindingChecker.this.createContextFlagsString(name);
                                                                            problemBinding = (IProblemBinding)binding;
                                                                            id = problemBinding.getID();
                                                                            if (id != 2) break block29;
                                                                            ProblemBindingChecker.this.reportProblem(ERR_ID_OverloadProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                                                                            return 3;
                                                                        }
                                                                        if (id != 4) break block30;
                                                                        String candidatesString = ProblemBindingChecker.this.getCandidatesString(problemBinding);
                                                                        ProblemBindingChecker.this.reportProblem(ERR_ID_AmbiguousProblem, (IASTNode)name, new Object[]{name.getRawSignature(), candidatesString, contextFlagsString});
                                                                        return 3;
                                                                    }
                                                                    if (id != 6) break block31;
                                                                    if (parentNode instanceof IASTFieldReference) {
                                                                        IASTExpression ownerExpression = ((IASTFieldReference)parentNode).getFieldOwner();
                                                                        typeString = ASTTypeUtil.getType((IType)ownerExpression.getExpressionType());
                                                                        problemNode = ownerExpression;
                                                                    } else {
                                                                        problemNode = name;
                                                                        typeString = name.getRawSignature();
                                                                    }
                                                                    ProblemBindingChecker.this.reportProblem(ERR_ID_CircularReferenceProblem, (IASTNode)problemNode, new Object[]{typeString, contextFlagsString});
                                                                    return 3;
                                                                }
                                                                if (id != 17) break block32;
                                                                IASTNode problemNode = parentNode;
                                                                while (problemNode != null) {
                                                                    if (problemNode instanceof ICPPASTStructuredBindingDeclaration) break;
                                                                    problemNode = problemNode.getParent();
                                                                }
                                                                if (problemNode == null) {
                                                                    problemNode = parentNode;
                                                                }
                                                                ProblemBindingChecker.this.reportProblem(ERR_ID_StructuredBindingDeclarationProblem, problemNode, new Object[]{parentNode.getRawSignature(), contextFlagsString});
                                                                return 3;
                                                            }
                                                            if (id != 12) break block33;
                                                            ProblemBindingChecker.this.reportProblem(ERR_ID_RedeclarationProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                                                            return 3;
                                                        }
                                                        if (id != 11) break block34;
                                                        ProblemBindingChecker.this.reportProblem(ERR_ID_RedefinitionProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                                                        return 3;
                                                    }
                                                    if (id != 13) break block35;
                                                    ProblemBindingChecker.this.reportProblem(ERR_ID_MemberDeclarationNotFoundProblem, (IASTNode)name, new Object[]{contextFlagsString});
                                                    return 3;
                                                }
                                                if (id != 9) break block36;
                                                ProblemBindingChecker.this.reportProblem(ERR_ID_LabelStatementNotFoundProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                                                return 3;
                                            }
                                            if (id != 15) break block37;
                                            IASTNode templateName = ProblemBindingChecker.this.getTemplateName(name);
                                            ProblemBindingChecker.this.reportProblem(ERR_ID_InvalidTemplateArgumentsProblem, templateName, new Object[]{contextFlagsString});
                                            return 3;
                                        }
                                        if (id != 5) break block38;
                                        ProblemBindingChecker.this.reportProblem(ERR_ID_TypeResolutionProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                                        return 3;
                                    }
                                    if (id != 18) break block39;
                                    if (ProblemBindingChecker.this.isFunctionCall(name, parentNode)) {
                                        ProblemBindingChecker.this.reportProblem(ERR_ID_TemplateInstantiationProblem, (IASTNode)name.getLastName(), new Object[]{ProblemBindingChecker.this.getCandidatesString(problemBinding), contextFlagsString});
                                    }
                                    return 3;
                                }
                                if (id == 1) break block40;
                                return 3;
                            }
                            if (!SemanticQueries.isUnknownBuiltin((IProblemBinding)problemBinding, (IASTNode)name)) break block41;
                            return 3;
                        }
                        try {
                            if (ProblemBindingChecker.this.isFunctionCall(name, parentNode)) {
                                ProblemBindingChecker.this.handleFunctionProblem(name, problemBinding, contextFlagsString);
                            } else if (parentNode instanceof IASTFieldReference) {
                                ProblemBindingChecker.this.handleMemberProblem(name, parentNode, problemBinding, contextFlagsString);
                            } else if (parentNode instanceof IASTNamedTypeSpecifier) {
                                ProblemBindingChecker.this.reportProblem(ERR_ID_TypeResolutionProblem, (IASTNode)name, new Object[]{name.getRawSignature(), contextFlagsString});
                            } else {
                                ProblemBindingChecker.this.handleVariableProblem(name, contextFlagsString);
                            }
                        }
                        catch (DOMException e) {
                            CodanCheckersActivator.log(e);
                        }
                    }
                    return 3;
                }
            });
        }
        catch (Exception e) {
            CodanCheckersActivator.log(e);
        }
    }

    protected String createContextFlagsString(IASTName name) {
        StringBuilder buf = new StringBuilder();
        if (this.isInClassContext(name)) {
            buf.append(":class");
        }
        if (this.isInFunctionContext(name)) {
            buf.append(":func");
        }
        return buf.toString();
    }

    private boolean isInClassContext(IASTName name) {
        if (CxxAstUtils.getEnclosingCompositeTypeSpecifier((IASTNode)name) != null) {
            return true;
        }
        IASTFunctionDefinition function = CxxAstUtils.getEnclosingFunction((IASTNode)name);
        if (function == null) {
            return false;
        }
        IASTDeclarator innermostDeclarator = ASTQueries.findInnermostDeclarator((IASTDeclarator)function.getDeclarator());
        IBinding binding = innermostDeclarator.getName().resolveBinding();
        return binding instanceof ICPPMethod;
    }

    private boolean isInFunctionContext(IASTName name) {
        IASTFunctionDefinition function = CxxAstUtils.getEnclosingFunction((IASTNode)name);
        return function != null;
    }

    private void handleFunctionProblem(IASTName name, IProblemBinding problemBinding, String contextFlagsString) throws DOMException {
        if (problemBinding.getCandidateBindings().length == 0) {
            this.reportProblem(ERR_ID_FunctionResolutionProblem, (IASTNode)name.getLastName(), new Object[]{new String(name.getSimpleID()), contextFlagsString});
        } else {
            String candidatesString = this.getCandidatesString(problemBinding);
            this.reportProblem(ERR_ID_InvalidArguments, (IASTNode)name.getLastName(), new Object[]{candidatesString, contextFlagsString});
        }
    }

    private void handleMemberProblem(IASTName name, IASTNode parentNode, IProblemBinding problemBinding, String contextFlagsString) throws DOMException {
        boolean isMethod;
        IASTNode parentParentNode = parentNode.getParent();
        boolean bl = isMethod = parentParentNode instanceof IASTFunctionCallExpression && parentParentNode.getChildren()[0] == parentNode;
        if (isMethod) {
            if (problemBinding.getCandidateBindings().length == 0) {
                this.reportProblem(ERR_ID_MethodResolutionProblem, (IASTNode)name.getLastName(), new Object[]{new String(name.getSimpleID()), contextFlagsString});
            } else {
                String candidatesString = this.getCandidatesString(problemBinding);
                this.reportProblem(ERR_ID_InvalidArguments, (IASTNode)name.getLastName(), new Object[]{candidatesString, contextFlagsString});
            }
        } else {
            this.reportProblem(ERR_ID_FieldResolutionProblem, (IASTNode)name.getLastName(), new Object[]{name.getRawSignature(), contextFlagsString});
        }
    }

    private void handleVariableProblem(IASTName name, String contextFlagsString) {
        this.reportProblem(ERR_ID_VariableResolutionProblem, (IASTNode)name, new Object[]{name.getBinding().getName(), contextFlagsString, name.getRawSignature()});
    }

    private boolean isFunctionCall(IASTName name, IASTNode parentNode) {
        if (parentNode instanceof IASTIdExpression) {
            IASTIdExpression expression = (IASTIdExpression)parentNode;
            IASTNode parentParentNode = expression.getParent();
            if (parentParentNode instanceof IASTFunctionCallExpression && expression.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                return true;
            }
        } else {
            if (parentNode instanceof ICPPASTDeclarator && name instanceof IASTImplicitName) {
                return true;
            }
            if (parentNode instanceof ICPPASTLiteralExpression && name instanceof IASTImplicitName) {
                return true;
            }
        }
        return false;
    }

    protected IASTNode getTemplateName(IASTName name) {
        IASTName nameToGetTempate = name.getLastName();
        if (nameToGetTempate instanceof ICPPASTTemplateId) {
            return ((ICPPASTTemplateId)nameToGetTempate).getTemplateName();
        }
        return nameToGetTempate;
    }

    private String getCandidatesString(IProblemBinding problemBinding) throws DOMException {
        String candidatesString = "\n" + CheckersMessages.ProblemBindingChecker_Candidates + "\n";
        String lastSignature = "";
        IBinding[] iBindingArray = problemBinding.getCandidateBindings();
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding candidateBinding = iBindingArray[n2];
            if (candidateBinding instanceof ICPPFunction) {
                ICPPFunction functionBinding = (ICPPFunction)candidateBinding;
                String signature = this.getFunctionSignature(functionBinding);
                if (!signature.equals(lastSignature)) {
                    candidatesString = candidatesString + signature + "\n";
                    lastSignature = signature;
                }
            } else if (candidateBinding instanceof ICPPClassType) {
                ICPPClassType classType = (ICPPClassType)candidateBinding;
                try {
                    CPPSemantics.pushLookupPoint((IASTNode)problemBinding.getASTNode());
                    ICPPConstructor[] iCPPConstructorArray = classType.getConstructors();
                    int n3 = iCPPConstructorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPConstructor constructor = iCPPConstructorArray[n4];
                        String signature = this.getFunctionSignature((ICPPFunction)constructor);
                        if (!signature.equals(lastSignature)) {
                            candidatesString = candidatesString + signature + "\n";
                            lastSignature = signature;
                        }
                        ++n4;
                    }
                }
                finally {
                    CPPSemantics.popLookupPoint();
                }
            }
            ++n2;
        }
        return candidatesString;
    }

    private String getFunctionSignature(ICPPFunction functionBinding) throws DOMException {
        ICPPFunctionType functionType = functionBinding.getType();
        String returnTypeString = ASTTypeUtil.getType((IType)functionBinding.getType().getReturnType()) + " ";
        String functionName = functionBinding.getName();
        String parameterTypeString = ASTTypeUtil.getParameterTypeString((IFunctionType)functionType);
        return returnTypeString + functionName + parameterTypeString;
    }
}

