/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2AliasImpl;
import org.eclipse.datatools.enablement.ibm.util.CloneUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogAlias
extends DB2AliasImpl
implements ICatalogObject,
IDatabaseObject {
    private boolean aliasedTableLoaded = false;
    private boolean columnsLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();

    public void refresh() {
        this.aliasedTableLoaded = false;
        this.columnsLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public String getDescription() {
        if (!this.aliasedTableLoaded) {
            this.loadAliasedTable();
        }
        return this.description;
    }

    public Table getAliasedTable() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getAliasedTable();
        }
        if (!this.aliasedTableLoaded) {
            this.loadAliasedTable();
        }
        return this.aliasedTable;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 3) {
            this.getDescription();
        } else if (id == 18) {
            this.getAliasedTable();
        } else if (id == 8) {
            this.getColumns();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadAliasedTable() {
        if (this.aliasedTableLoaded) {
            return;
        }
        this.aliasedTableLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT BASE_TABSCHEMA, BASE_TABNAME,REMARKS FROM SYSCAT.TABLES WHERE TABSCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(this.getName()) + "'");
            r.next();
            String aliasedSchemaName = r.getString(1).trim();
            String aliasedTableName = r.getString(2);
            this.setAliasedTable(this.getTable(aliasedSchemaName, aliasedTableName));
            this.setDescription(r.getString(3));
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private Table getTable(String schemaName, String tableName) {
        LUWCatalogTable table2;
        Table t;
        Schema schema = this.getSchema(schemaName);
        if (schema instanceof LUWCatalogSchema && (t = ((LUWCatalogSchema)schema).getTable(schemaName, tableName)) != null) {
            return t;
        }
        for (LUWCatalogTable table2 : schema.getTables()) {
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        table2 = new LUWCatalogTable();
        table2.setName(tableName);
        table2.setSchema(schema);
        return table2;
    }

    private Schema getSchema(String schemaName) {
        Schema s2 = this.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database db = s2.getDatabase();
        if (db instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)db).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : db.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(db);
        if (db instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)db).cacheSchema((Schema)schema);
        }
        return schema;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTable.getImpactedAlias(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTables(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedRoutines(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTriggers(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedPackages(connection, (Table)this));
        return impacts;
    }

    private void cloneColumn(Column src, Column target) {
        target.setName(src.getName());
        DataType datatype = src.getDataType();
        if (datatype instanceof SQLDataType) {
            DataType newDataType = (DataType)CloneUtil.cloneSingleObject((EObject)datatype);
            target.setDataType(newDataType);
        } else {
            target.setDataType(datatype);
        }
    }
}

