/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class Workspaces {
    private static ServiceTracker<Workspace, Workspace> tracker;

    public static Optional<Workspace> getWorkspace(IProject project) {
        if (project != null) {
            Project bndProject = (Project)Adapters.adapt((Object)project, Project.class);
            if (bndProject != null) {
                return Optional.ofNullable(bndProject.getWorkspace());
            }
            if (Workspaces.isCnf(project)) {
                try {
                    File wsDir = project.getLocation().toFile().getParentFile();
                    return Optional.ofNullable(Workspace.getWorkspace((File)wsDir));
                }
                catch (Exception wsDir) {}
            } else {
                File file;
                IPath location;
                IFile bndFile = project.getFile("bnd.bnd");
                if (bndFile.exists() && (location = bndFile.getLocation()) != null && (file = location.toFile()) != null) {
                    try {
                        Project nativeProject = Workspace.getProject((File)file.getParentFile());
                        if (nativeProject != null) {
                            return Optional.ofNullable(nativeProject.getWorkspace());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isCnf(IProject project) {
        IPath projectPath = project.getLocation();
        if (projectPath != null) {
            return "cnf".equals(projectPath.lastSegment());
        }
        return false;
    }

    public static synchronized Optional<Workspace> getGlobalWorkspace() {
        if (tracker == null) {
            Bundle bundle = FrameworkUtil.getBundle(Workspaces.class);
            if (bundle == null) {
                return Optional.empty();
            }
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return Optional.empty();
            }
            tracker = new ServiceTracker(bundleContext, Workspace.class, null);
            tracker.open();
        }
        return Optional.ofNullable((Workspace)tracker.getService());
    }

    public static String getName(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        String name = workspace.get("workspaceName");
        if (name != null && !name.isBlank()) {
            return name;
        }
        return workspace.getBase().getName();
    }

    public static String getDescription(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        String name = workspace.get("workspaceDescription");
        if (name != null && !name.isBlank()) {
            return name;
        }
        return String.format("Workspace at location %s", workspace.getBase().getAbsolutePath());
    }
}

