/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.Logger;

public class FileContentCache {
    static final boolean DEBUG = false;
    static FileContentCache instance = new FileContentCache();
    private LinkedHashMap fContentMap = new LimitedHashMap();

    public static FileContentCache getInstance() {
        return instance;
    }

    private FileContentCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        LinkedHashMap linkedHashMap = this.fContentMap;
        synchronized (linkedHashMap) {
            Iterator iterator = this.fContentMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() == null || ((Reference)entry.getValue()).get() != null) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContents(IPath filePath) {
        IDocument document;
        ITextFileBuffer existingBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(filePath, LocationKind.NORMALIZE);
        if (existingBuffer != null && (document = existingBuffer.getDocument()) != null) {
            return document.get();
        }
        CacheEntry entry = null;
        Object o = this.fContentMap.get(filePath);
        if (o instanceof Reference) {
            entry = (CacheEntry)((Reference)o).get();
        }
        if (entry == null || entry.isStale()) {
            entry = new CacheEntry(filePath);
            LinkedHashMap linkedHashMap = this.fContentMap;
            synchronized (linkedHashMap) {
                this.fContentMap.put(filePath, new SoftReference<CacheEntry>(entry));
            }
        }
        this.cleanup();
        return entry.contents;
    }

    private static class CacheEntry {
        String contents;
        long modificationStamp = -1L;
        IPath contentPath;

        CacheEntry(IPath path) {
            this.contentPath = path;
            this.modificationStamp = this.getModificationStamp(path);
            this.contents = this.readContents(path);
        }

        private IFile getFile(IPath path) {
            if (path.segmentCount() > 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            return null;
        }

        boolean isStale() {
            if (this.modificationStamp == -1L) {
                return true;
            }
            long newStamp = this.getModificationStamp(this.contentPath);
            return newStamp > this.modificationStamp;
        }

        private String detectCharset(String name, byte[] contents) throws IOException {
            IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((InputStream)new ByteArrayInputStream(contents), name, new QualifiedName[]{IContentDescription.CHARSET});
            if (description != null) {
                String charset = description.getCharset();
                if (charset == null && description.getContentType() != null) {
                    charset = description.getContentType().getDefaultCharset();
                }
                if (charset != null) {
                    return charset;
                }
            }
            return ResourcesPlugin.getEncoding();
        }

        private long getModificationStamp(IPath filePath) {
            IFile f = this.getFile(filePath);
            if (f != null && f.isAccessible()) {
                return f.getModificationStamp();
            }
            File file = filePath.toFile();
            if (file.exists()) {
                return file.lastModified();
            }
            return -1L;
        }

        /*
         * Unable to fully structure code
         */
        private String readContents(IPath filePath) {
            block30: {
                is = null;
                f = this.getFile(filePath);
                is = f != null && f.isAccessible() != false ? f.getContents(true) : new FileInputStream(filePath.toFile());
                store = new ByteArrayOutputStream();
                readBuffer = new byte[8092];
                n = is.read(readBuffer);
                while (n > 0) {
                    store.write(readBuffer, 0, n);
                    n = is.read(readBuffer);
                }
                bytes = store.toByteArray();
                charset = this.detectCharset(filePath.lastSegment(), bytes);
                buffer = ByteBuffer.wrap(bytes);
                charBuffer = Charset.forName(charset).decode(buffer);
                var12_12 = charBuffer.toString();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception v0) {}
                return var12_12;
                {
                    catch (IllegalCharsetNameException v1) {
                        var12_13 = new String(bytes, charset);
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception v2) {}
                        return var12_13;
                    }
                    catch (UnsupportedCharsetException v3) {
                        var12_14 = new String(bytes, charset);
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception v4) {}
                        return var12_14;
                        {
                            catch (CoreException e) {
                                Logger.logException(e);
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    break block30;
                                }
                                catch (Exception v5) {}
                                break block30;
                            }
                            catch (Exception v6) {
                                ** try [egrp 9[TRYBLOCK] [17 : 236->237)] { 
lbl-1000:
                                // 5 sources

                                {
                                    catch (Throwable var11_15) {
                                        try {
                                            if (is != null) {
                                                is.close();
                                            }
                                        }
                                        catch (Exception v7) {}
                                        throw var11_15;
                                    }
                                }
lbl61:
                                // 1 sources

                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                catch (Exception v8) {}
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    static class LimitedHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        LimitedHashMap() {
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 25;
        }
    }
}

