/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDDirectivesManager;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLImportManager
extends XSDDirectivesManager {
    protected Definition definition;
    protected Map schemaToUsedPrefixesMap;
    protected Map schemaToUnusedPrefixesMap;
    protected Set usedWSDLPrefixes;
    protected Set unusedWSDLPrefixes;
    protected List usedDefinitions;
    protected List unusedWSDLImports;

    public static void removeUnusedImports(Definition definition) {
        if (WSDLEditorPlugin.getInstance().getRemoveImportSetting()) {
            WSDLImportManager mgr = new WSDLImportManager();
            mgr.performRemoval(definition);
            mgr.cleanup();
        }
    }

    public void performRemoval(Definition definition) {
        this.definition = definition;
        this.computeUnusedImports(definition);
        this.removeUnusedImports();
        this.removeUnusedPrefixes();
    }

    public List getUnusedImports() {
        return this.unusedDirectives;
    }

    public List getWSDLUnusedImports() {
        return this.unusedWSDLImports;
    }

    public Set getUnusedWSDLPrefixes() {
        return this.unusedWSDLPrefixes;
    }

    protected void computeUnusedImports(Definition definition) {
        ArrayList usedSchemas = new ArrayList();
        this.unusedDirectives = new ArrayList();
        this.usedPrefixes = new HashSet();
        this.schemaToPrefixMap = new HashMap();
        this.schemaToUsedPrefixesMap = new HashMap();
        this.schemaToUnusedPrefixesMap = new HashMap();
        this.usedDefinitions = new ArrayList();
        this.unusedWSDLImports = new ArrayList();
        this.usedWSDLPrefixes = new HashSet();
        this.unusedWSDLPrefixes = new HashSet();
        Types types = definition.getETypes();
        if (types != null) {
            try {
                Map xsdNamedComponentUsage = XSDDirectivesManager.TopLevelComponentCrossReferencer.find((EObject)definition);
                for (XSDSchema schema : types.getSchemas()) {
                    this.usedPrefixes.clear();
                    this.doCrossReferencer(schema, usedSchemas, xsdNamedComponentUsage);
                    this.addToUnusedImports(schema, usedSchemas);
                    this.computeUnusedPrefixes(schema);
                }
            }
            catch (Exception exception) {
                this.unusedDirectives.clear();
                this.schemaToPrefixMap.clear();
            }
        }
        this.computeUsedDefinitions(definition);
        this.analyzeDefinitionXMLNSTable(definition);
        this.computeUnusedWSDLImports(definition);
        this.unusedWSDLPrefixes = this.computeUnusedPrefixes(definition);
    }

    private void computeUsedDefinitions(Definition definition) {
        Map wsdlNamedComponentUsage = WSDLNamedComponentCrossReferencer.find((EObject)definition);
        for (WSDLElement wsdlElement : wsdlNamedComponentUsage.keySet()) {
            Definition wsdlElementDef = wsdlElement.getEnclosingDefinition();
            if (wsdlElementDef == definition) continue;
            Collection collection = (Collection)wsdlNamedComponentUsage.get(wsdlElement);
            for (EStructuralFeature.Setting setting : collection) {
                EObject obj = setting.getEObject();
                if (!this.isComponentUsed((Object)obj, definition, wsdlElementDef) || this.usedDefinitions.contains(wsdlElementDef)) continue;
                this.usedDefinitions.add(wsdlElementDef);
            }
        }
    }

    private void computeUnusedWSDLImports(Definition definition) {
        for (Object obj : definition.getEImports()) {
            if (!(obj instanceof Import)) continue;
            Import imp = (Import)obj;
            Definition def = imp.getEDefinition();
            XSDSchema schema = imp.getESchema();
            boolean isUsed = false;
            if (def != null) {
                for (Definition used : this.usedDefinitions) {
                    if (used != def) continue;
                    isUsed = true;
                    break;
                }
            }
            if (schema != null) {
                String ns = imp.getNamespaceURI();
                Map defPrefixMap = definition.getNamespaces();
                Set wsdlKeys = defPrefixMap.keySet();
                boolean prefixFound = false;
                String pref2 = null;
                for (String pref2 : wsdlKeys) {
                    String aNS = (String)defPrefixMap.get(pref2);
                    if ((aNS == null || !aNS.equals(ns)) && aNS != ns) continue;
                    prefixFound = true;
                    break;
                }
                if (prefixFound && (this.usedPrefixes.contains(pref2) || this.usedWSDLPrefixes.contains(pref2))) {
                    isUsed = true;
                }
            }
            if (isUsed) continue;
            this.unusedWSDLImports.add(imp);
        }
    }

    protected void removeUnusedImports() {
        super.removeUnusedImports();
        for (Import wsdlImport : this.unusedWSDLImports) {
            Element element = wsdlImport.getElement();
            Document doc = element.getOwnerDocument();
            if (doc instanceof IDOMNode) {
                ((IDOMNode)doc).getModel().aboutToChangeModel();
            }
            try {
                if (!this.removeTextNodesBetweenNextElement(element)) {
                    this.removeTextNodeBetweenPreviousElement(element);
                }
                element.getParentNode().removeChild(element);
            }
            finally {
                if (doc instanceof IDOMNode) {
                    ((IDOMNode)doc).getModel().changedModel();
                }
            }
        }
    }

    private void analyzeDefinitionXMLNSTable(Definition definition) {
        String prefix = definition.getPrefix(definition.getTargetNamespace());
        this.usedWSDLPrefixes.add(prefix);
        String wsdlPrefix = definition.getPrefix("http://schemas.xmlsoap.org/wsdl/");
        this.usedWSDLPrefixes.add(wsdlPrefix);
        Element element = definition.getElement();
        NodeList childElements = element.getChildNodes();
        int length = childElements.getLength();
        int index = 0;
        while (index < length) {
            Node node = childElements.item(index);
            if (node instanceof Element) {
                this.traverseDOMElement((Element)node, definition);
            }
            ++index;
        }
    }

    protected void removeUnusedPrefixes() {
        super.removeUnusedPrefixes();
        Map defPrefixMap = this.definition.getNamespaces();
        for (String string : this.unusedWSDLPrefixes) {
            defPrefixMap.remove(string != null ? string : "");
            Element element = this.definition.getElement();
            if (element == null) continue;
            if (string != null) {
                element.removeAttribute("xmlns:" + string);
                continue;
            }
            element.removeAttribute("xmlns");
        }
    }

    private Set computeUnusedPrefixes(Definition definition) {
        Map defPrefixMap = definition.getNamespaces();
        Set wsdlKeys = defPrefixMap.keySet();
        HashSet<String> netSet = new HashSet<String>();
        Types eTypes = definition.getETypes();
        EList extElements = new ArrayList();
        if (eTypes != null) {
            extElements = definition.getETypes().getEExtensibilityElements();
            for (Object ee : extElements) {
                if (!(ee instanceof XSDSchemaExtensibilityElement)) continue;
                XSDSchemaExtensibilityElement xsdEx = (XSDSchemaExtensibilityElement)ee;
                XSDSchema inlineXSD = xsdEx.getSchema();
                this.usedWSDLPrefixes.add(inlineXSD.getSchemaForSchemaQNamePrefix());
            }
        }
        for (String aWsdlPrefix : wsdlKeys) {
            if (aWsdlPrefix != null && aWsdlPrefix.equals("")) {
                aWsdlPrefix = null;
            }
            String nsForWSDLPrefix = (String)defPrefixMap.get(aWsdlPrefix);
            if (this.usedWSDLPrefixes.contains(aWsdlPrefix)) continue;
            boolean canRemoveWSDLPrefix = true;
            for (Object ee : extElements) {
                String nsForXSDPrefix;
                if (!(ee instanceof XSDSchemaExtensibilityElement)) continue;
                XSDSchemaExtensibilityElement xsdEx = (XSDSchemaExtensibilityElement)ee;
                XSDSchema inlineXSD = xsdEx.getSchema();
                Map inlineXSDMap = inlineXSD.getQNamePrefixToNamespaceMap();
                Set usedInlineXSDPrefixes = (Set)this.schemaToUsedPrefixesMap.get(inlineXSD);
                if (!usedInlineXSDPrefixes.contains(aWsdlPrefix) || ((nsForXSDPrefix = (String)inlineXSDMap.get(aWsdlPrefix)) == null || !nsForXSDPrefix.equals(nsForWSDLPrefix)) && (nsForXSDPrefix != null || nsForWSDLPrefix != null)) continue;
                canRemoveWSDLPrefix = false;
            }
            if (!canRemoveWSDLPrefix) continue;
            netSet.add(aWsdlPrefix);
        }
        return netSet;
    }

    protected void doAdditionalProcessing(XSDSchema schema) {
        this.schemaToUsedPrefixesMap.put(schema, new HashSet(this.usedPrefixes));
        this.schemaToUnusedPrefixesMap.put(schema, new HashSet(this.unusedPrefixes));
    }

    private void traverseDOMElement(Element element, Definition definition) {
        String prefix = element.getPrefix();
        this.usedWSDLPrefixes.add(prefix);
        NamedNodeMap attrs = element.getAttributes();
        int numOfAttrs = attrs.getLength();
        int index = 0;
        while (index < numOfAttrs) {
            String value;
            String attr;
            Node node = attrs.item(index);
            String attrPrefix = node.getPrefix();
            if (attrPrefix != null && !attrPrefix.equals("xmlns")) {
                this.usedWSDLPrefixes.add(attrPrefix);
            }
            if ((attr = node.getLocalName()) != null && (value = node.getNodeValue()) != null && (attr.equals("binding") || attr.equals("type") || attr.equals("element") || attr.equals("message"))) {
                this.usedWSDLPrefixes.add(this.extractPrefix(value));
            }
            ++index;
        }
        NodeList childElements = element.getChildNodes();
        int length = childElements.getLength();
        int index2 = 0;
        while (index2 < length) {
            Node node = childElements.item(index2);
            if (node instanceof Element) {
                if ("schema".equals(((Element)node).getLocalName())) {
                    this.usedWSDLPrefixes.add(node.getPrefix());
                } else {
                    this.traverseDOMElement((Element)node, definition);
                }
            }
            ++index2;
        }
    }

    protected boolean isComponentUsed(Object obj, XSDSchema schema, XSDSchema targetSchema) {
        if (obj instanceof XSDConcreteComponent) {
            return super.isComponentUsed(obj, schema, targetSchema);
        }
        if (obj instanceof Part) {
            Part part = (Part)obj;
            XSDElementDeclaration elem = part.getElementDeclaration();
            XSDTypeDefinition type = part.getTypeDefinition();
            if (elem != null && elem.getSchema() == targetSchema) {
                String value = part.getElement().getAttribute("element");
                String pref = this.extractPrefix(value);
                this.usedPrefixes.add(pref);
                this.usedWSDLPrefixes.add(pref);
                return true;
            }
            if (type != null && type.getSchema() == targetSchema) {
                String value = part.getElement().getAttribute("type");
                String pref = this.extractPrefix(value);
                this.usedPrefixes.add(pref);
                this.usedWSDLPrefixes.add(pref);
                return true;
            }
        }
        return false;
    }

    protected void clearMaps() {
        super.clearMaps();
        if (this.schemaToUsedPrefixesMap != null) {
            this.schemaToUsedPrefixesMap.clear();
        }
        if (this.schemaToUnusedPrefixesMap != null) {
            this.schemaToUnusedPrefixesMap.clear();
        }
        if (this.usedDefinitions != null) {
            this.usedDefinitions.clear();
        }
    }

    protected boolean isComponentUsed(Object obj, Definition definition, Definition targetDefinition) {
        if (obj instanceof WSDLElement) {
            WSDLElement component = (WSDLElement)obj;
            return component != definition && !(component instanceof Definition);
        }
        return false;
    }

    protected static class WSDLNamedComponentCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;

        protected WSDLNamedComponentCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected WSDLNamedComponentCrossReferencer(Resource resource) {
            super(resource);
        }

        protected WSDLNamedComponentCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected WSDLNamedComponentCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean containment(EObject eObject) {
            if (WSDLNamedComponentCrossReferencer.isWSDLNamedComponent(eObject)) {
                this.getCollection(eObject);
            }
            return true;
        }

        protected static boolean isWSDLNamedComponent(EObject eObject) {
            return eObject instanceof Message || eObject instanceof PortType || eObject instanceof Binding || eObject instanceof Port;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !eReference.isVolatile() && eReference.isChangeable() && WSDLNamedComponentCrossReferencer.isWSDLNamedComponent(crossReferencedEObject);
        }

        public static Map find(EObject eObject) {
            WSDLNamedComponentCrossReferencer result = new WSDLNamedComponentCrossReferencer(eObject);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map find(Resource resource) {
            WSDLNamedComponentCrossReferencer result = new WSDLNamedComponentCrossReferencer(resource);
            result.crossReference();
            result.done();
            return result;
        }

        public static Map find(ResourceSet resourceSet) {
            WSDLNamedComponentCrossReferencer result = new WSDLNamedComponentCrossReferencer(resourceSet);
            result.crossReference();
            result.done();
            return result;
        }
    }
}

