/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions.NavigateToImplementationAction;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions.OpenWSResourceAction;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class WSActionProvider
extends CommonActionProvider {
    private OpenWSResourceAction openAction;
    private NavigateToImplementationAction navigateAction;

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
        if (this.navigateAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.navigateAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.getContext() == null || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openAction.selectionChanged(selection);
        this.navigateAction.selectionChanged(selection);
        this.navigateAction.setText(this.navigateAction.getText());
        if (this.openAction.isEnabled()) {
            menu.insertAfter("group.open", (IAction)this.openAction);
        }
        if (this.navigateAction.isEnabled()) {
            menu.insertAfter("group.openWith", (IAction)this.navigateAction);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.openAction = new OpenWSResourceAction();
        this.navigateAction = this.initNavigateAction(site);
    }

    protected NavigateToImplementationAction initNavigateAction(ICommonActionExtensionSite site) {
        return new NavigateToImplementationAction(site.getStructuredViewer());
    }

    public void setContext(ActionContext context) {
        if (context != null && context.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)context.getSelection();
            if (selection instanceof ITreeSelection) {
                TreePath[] paths = ((ITreeSelection)selection).getPathsFor(selection.getFirstElement());
                IProject project = null;
                int ii = 0;
                while (ii < paths.length) {
                    TreePath path = paths[ii];
                    IServiceEndpointInterface sei = null;
                    int jj = 0;
                    while (jj < path.getSegmentCount()) {
                        if (path.getSegment(jj) instanceof IServiceEndpointInterface) {
                            sei = (IServiceEndpointInterface)path.getSegment(jj);
                            break;
                        }
                        ++jj;
                    }
                    jj = 0;
                    while (jj < path.getSegmentCount()) {
                        if (path.getSegment(jj) instanceof IProject) {
                            project = (IProject)path.getSegment(jj);
                            this.openAction.selectionChanged(selection, this.getJavaProject(project), sei);
                            this.navigateAction.selectionChanged(selection, this.getJavaProject(project));
                            super.setContext(context);
                            return;
                        }
                        ++jj;
                    }
                    ++ii;
                }
            }
            this.openAction.selectionChanged(selection);
            this.navigateAction.selectionChanged(selection);
        }
        super.setContext(context);
    }

    protected IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }
}

