/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.model.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReverseNavigationHelper {
    public static final int SINGLE = 1;
    public static final int MULTIPLE = -1;

    public static class InverseAdapter
    extends AdapterImpl {
        protected EReference reference;
        protected int inverseCardinality;

        public InverseAdapter(EReference reference) {
            this(reference, 1);
        }

        public InverseAdapter(EReference reference, int inverseCardinality) {
            this.reference = reference;
            this.inverseCardinality = inverseCardinality;
        }

        public Object getOppositeEnd(Notifier target) {
            Object source = null;
            TargetAdapter a = null;
            for (Adapter adapter : target.eAdapters()) {
                if (!adapter.isAdapterForType((Object)this.reference) || !(adapter instanceof TargetAdapter)) continue;
                a = (TargetAdapter)adapter;
                break;
            }
            if (a == null) {
                a = this.inverseCardinality == 1 ? (TargetAdapter)TargetAdapterFactory.SINGLE_SOURCE.adapt(target, this.reference) : (TargetAdapter)TargetAdapterFactory.MULTIPLE_SOURCE.adapt(target, this.reference);
            }
            if (a != null) {
                source = a.getSource();
            }
            return source;
        }

        public boolean isAdapterForType(Object type) {
            return type == InverseAdapter.class;
        }

        public void notifyChanged(Notification notification) {
            if (!this.reference.equals(notification.getFeature())) {
                return;
            }
            int eventType = notification.getEventType();
            Object oldTarget = notification.getOldValue();
            Object newTarget = notification.getNewValue();
            EObject source = (EObject)notification.getNotifier();
            switch (eventType) {
                case 1: {
                    this.removeSourceFromOldTarget(source, (Notifier)((EObject)oldTarget));
                    this.addNewSourceToNewTarget(notification, (EObject)newTarget, -1);
                    break;
                }
                case 2: {
                    this.removeSourceFromOldTarget(source, (Notifier)((EObject)oldTarget));
                    break;
                }
                case 3: {
                    this.addNewSourceToNewTarget(notification, (EObject)newTarget, notification.getPosition());
                    break;
                }
                case 5: {
                    ((List)newTarget).iterator();
                    List targetList = (List)newTarget;
                    int i = 0;
                    int size = targetList.size();
                    while (i < size) {
                        this.addNewSourceToNewTarget(notification, (EObject)targetList.get(i), i);
                        ++i;
                    }
                    break;
                }
                case 4: {
                    this.removeSourceFromOldTarget(source, (Notifier)((EObject)oldTarget));
                    break;
                }
                case 6: {
                    Iterator r = ((List)oldTarget).iterator();
                    while (r.hasNext()) {
                        this.removeSourceFromOldTarget(source, (Notifier)((EObject)r.next()));
                    }
                    break;
                }
                case 9: {
                    this.removeSourceFromOldTarget(source, (Notifier)((EObject)oldTarget));
                    this.addNewSourceToNewTarget(notification, (EObject)newTarget, -1);
                }
            }
        }

        private void addNewSourceToNewTarget(Notification notification, EObject target, int pos) {
            if (target != null) {
                EObject newSource = (EObject)notification.getNotifier();
                if (target.eIsProxy()) {
                    if (this.reference.isMany()) {
                        List list = (List)newSource.eGet((EStructuralFeature)this.reference);
                        target = (EObject)list.get(pos);
                    } else {
                        target = (EObject)newSource.eGet((EStructuralFeature)this.reference);
                    }
                }
                TargetAdapter a = this.inverseCardinality == 1 ? (TargetAdapter)TargetAdapterFactory.SINGLE_SOURCE.adapt((Notifier)target, this.reference) : (TargetAdapter)TargetAdapterFactory.MULTIPLE_SOURCE.adapt((Notifier)target, this.reference);
                a.setSource(newSource);
            }
        }

        private void removeSourceFromOldTarget(EObject oldSource, Notifier target) {
            TargetAdapter a;
            if (target != null && (a = (TargetAdapter)EcoreUtil.getAdapter((List)target.eAdapters(), (Object)this.reference)) != null) {
                a.unsetSource(oldSource);
            }
        }
    }

    private static abstract class TargetAdapter
    extends AdapterImpl {
        protected EReference reference;

        public void setReference(EReference reference) {
            this.reference = reference;
        }

        protected EReference getReference() {
            return this.reference;
        }

        protected abstract Object getSource();

        protected abstract void setSource(Object var1);

        protected abstract void unsetSource(Object var1);

        protected TargetAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == this.reference;
        }

        public void notifyChanged(Notification notification) {
        }
    }

    private static class TargetAdapterFactory
    extends AdapterFactoryImpl {
        protected static TargetAdapterFactory SINGLE_SOURCE = new TargetAdapterFactory(){

            protected Adapter createAdapter(Notifier target) {
                TargetWithSingleSourceAdapter a = new TargetWithSingleSourceAdapter();
                a.setTarget(target);
                return a;
            }
        };
        protected static TargetAdapterFactory MULTIPLE_SOURCE = new TargetAdapterFactory(){

            protected Adapter createAdapter(Notifier target) {
                TargetWithMultipleSourceAdapter a = new TargetWithMultipleSourceAdapter();
                a.setTarget(target);
                return a;
            }
        };

        protected TargetAdapterFactory() {
        }

        protected Adapter createAdapter(Notifier target, Object type) {
            TargetAdapter t = (TargetAdapter)super.createAdapter(target, type);
            t.setReference((EReference)type);
            return t;
        }

        public boolean isFactoryForType(Object type) {
            EObject eObj;
            if (type instanceof EObject && (eObj = (EObject)type).eClass() == EcorePackage.eINSTANCE.getEReference()) {
                return true;
            }
            return super.isFactoryForType(type);
        }

        public Adapter adapt(Notifier target, Object type) {
            for (Adapter adapter : target.eAdapters()) {
                if (!adapter.isAdapterForType(type) || !(adapter instanceof TargetAdapter)) continue;
                return adapter;
            }
            return this.adaptNew(target, type);
        }
    }

    private static class TargetWithMultipleSourceAdapter
    extends TargetAdapter {
        private EList sourceList = null;

        private EList getSourceList() {
            if (this.sourceList == null) {
                this.sourceList = new BasicEList();
            }
            return this.sourceList;
        }

        @Override
        public Object getSource() {
            EList list = this.getSourceList();
            return new BasicEList.UnmodifiableEList(list.size(), list.toArray());
        }

        @Override
        protected void setSource(Object newSource) {
            EList newSourceList = this.getSourceList();
            newSourceList.add(newSource);
        }

        @Override
        protected void unsetSource(Object oldSource) {
            this.getSourceList().remove(oldSource);
        }
    }

    private static class TargetWithSingleSourceAdapter
    extends TargetAdapter {
        private EObject source = null;

        @Override
        protected void setSource(Object newSource) {
            EObject oldSource = (EObject)this.getSource();
            if (oldSource != null && oldSource != newSource) {
                if (this.reference.isMany()) {
                    EList oldTargetList = (EList)oldSource.eGet((EStructuralFeature)this.reference);
                    oldTargetList.remove((Object)this.target);
                } else {
                    oldSource.eUnset((EStructuralFeature)this.reference);
                }
            }
            this.source = (EObject)newSource;
        }

        @Override
        protected void unsetSource(Object oldSource) {
            this.source = null;
        }

        @Override
        protected Object getSource() {
            return this.source;
        }
    }
}

