/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReceiver;
import com.thaiopensource.validate.auto.ReparseException;
import com.thaiopensource.validate.auto.Rewindable;
import com.thaiopensource.validate.auto.RewindableInputStream;
import com.thaiopensource.validate.auto.RewindableReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AutoSchemaReader
extends AbstractSchemaReader {
    private final SchemaReceiverFactory srf;

    public AutoSchemaReader() {
        this(new SchemaReceiverLoader());
    }

    public AutoSchemaReader(SchemaReceiverFactory schemaReceiverFactory) {
        this.srf = schemaReceiverFactory == null ? new SchemaReceiverLoader() : schemaReceiverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler;
        Object object;
        Closeable closeable;
        Object object2;
        Object object3;
        if (propertyMap.get(SchemaReceiverFactory.PROPERTY) != this.srf) {
            object3 = new PropertyMapBuilder(propertyMap);
            ((PropertyMapBuilder)object3).put(SchemaReceiverFactory.PROPERTY, this.srf);
            propertyMap = ((PropertyMapBuilder)object3).toPropertyMap();
        }
        object3 = ResolverFactory.createResolver(propertyMap);
        InputSource inputSource = ((SAXResolver)object3).open(sAXSource.getInputSource());
        InputSource inputSource2 = new InputSource();
        inputSource2.setSystemId(inputSource.getSystemId());
        inputSource2.setPublicId(inputSource.getPublicId());
        inputSource2.setEncoding(inputSource.getEncoding());
        if (inputSource.getCharacterStream() != null) {
            object2 = new RewindableReader(inputSource.getCharacterStream());
            inputSource.setCharacterStream((Reader)object2);
            inputSource2.setCharacterStream((Reader)object2);
            closeable = object2;
        } else {
            object2 = inputSource.getByteStream();
            object = new RewindableInputStream((InputStream)object2);
            inputSource.setByteStream((InputStream)object);
            inputSource2.setByteStream((InputStream)object);
            closeable = object;
        }
        object2 = new AutoSchemaReceiver(propertyMap, (Rewindable)((Object)closeable));
        object = sAXSource.getXMLReader();
        if (object == null) {
            object = ((SAXResolver)object3).createXMLReader();
        }
        if ((errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER)) != null) {
            object.setErrorHandler(errorHandler);
        }
        SchemaFuture schemaFuture = object2.installHandlers((XMLReader)object);
        try {
            object.parse(inputSource);
            Schema schema = schemaFuture.getSchema();
            closeable.willNotRewind();
            return schema;
        }
        catch (ReparseException reparseException) {
            try {
                closeable.rewind();
                closeable.willNotRewind();
                Schema schema = reparseException.reparse(new SAXSource((XMLReader)object, inputSource2));
                closeable.willNotRewind();
                return schema;
            }
            catch (Throwable throwable) {
                try {
                    closeable.willNotRewind();
                    throw throwable;
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception instanceof RuntimeException) {
                        schemaFuture.unwrapException((RuntimeException)exception);
                    }
                    throw sAXException;
                }
                catch (RuntimeException runtimeException) {
                    throw schemaFuture.unwrapException(runtimeException);
                }
            }
        }
    }

    @Override
    public Option getOption(String string) {
        return this.srf.getOption(string);
    }
}

