/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.single;

import java.util.Map;
import org.eclipse.jst.pagedesigner.commands.single.SingleNodeCommand;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public class AddSubNodeCommand
extends SingleNodeCommand {
    private final IDOMElement _parent;
    private IDOMElement _child;
    private final String _tagName;
    private final String _url;
    private final Map _attributes;

    public AddSubNodeCommand(String label, IDOMElement node, String name, String url, Map attributs) {
        super(label, node);
        this._parent = node;
        this._tagName = name;
        this._url = url;
        this._attributes = attributs;
    }

    @Override
    protected void doExecute() {
        Object nodeName = null;
        if ("html".equals(this._url)) {
            nodeName = this._tagName;
        } else {
            String prefix = JSPUtil.getOrCreatePrefix(this._parent.getModel(), this._url, null);
            nodeName = prefix + ":" + this._tagName;
        }
        this._child = (IDOMElement)this._parent.getOwnerDocument().createElement((String)nodeName);
        if (this._child == null) {
            return;
        }
        for (String key : this._attributes.keySet()) {
            String value = (String)this._attributes.get(key);
            this._child.setAttribute(key, value);
        }
        this._parent.appendChild((Node)this._child);
    }

    public IDOMElement getChildNode() {
        return this._child;
    }
}

