/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class SafeTransformerWrapper<I, O>
implements Transformer<I, O> {
    private final Transformer<? super I, ? extends O> transformer;
    private final ExceptionHandler exceptionHandler;
    private final O exceptionOutput;

    public SafeTransformerWrapper(Transformer<? super I, ? extends O> transformer, ExceptionHandler exceptionHandler, O exceptionOutput) {
        if (transformer == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.exceptionHandler = exceptionHandler;
        this.exceptionOutput = exceptionOutput;
    }

    @Override
    public O transform(I input) {
        try {
            return this.transformer.transform(input);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
            return this.exceptionOutput;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.transformer);
    }
}

