/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.context.IDelegatingFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.designtime.context.AbstractDTExternalContextFactory;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.internal.BasicExtensionFactory;
import org.eclipse.jst.jsf.designtime.internal.DecoratableExtensionFactory;
import org.eclipse.jst.jsf.designtime.internal.resolver.ViewBasedTaglibResolverFactory;
import org.eclipse.jst.jsf.designtime.internal.view.AbstractDTViewHandler;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.osgi.framework.BundleContext;

public class JSFCorePlugin
extends WTPPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.jsf.core";
    public static final String TAG_REGISTRY_FACTORY_PROVIDER_ID = "tagRegistryFactory";
    private static JSFCorePlugin plugin;
    private IPreferenceStore preferenceStore;
    private ViewBasedTaglibResolverFactory _tagLibResolverFactory;
    private static DecoratableExtensionFactory<AbstractDTVariableResolver> _variableResolverFactory;
    private static final String VARIABLE_RESOLVER_EXT_POINT_NAME = "variableresolver";
    private static final String VARIABLE_RESOLVER_ELEMENT_NAME = "variableresolver";
    private static DecoratableExtensionFactory<AbstractDTPropertyResolver> _propertyResolverFactory;
    private static final String PROPERTY_RESOLVER_EXT_POINT_NAME = "propertyresolver";
    private static final String PROPERTY_RESOLVER_ELEMENT_NAME = "propertyresolver";
    private static BasicExtensionFactory<AbstractDTMethodResolver> _methodResolverFactory;
    private static final String METHOD_RESOLVER_EXT_POINT_NAME = "methodresolver";
    private static final String METHOD_RESOLVER_ELEMENT_NAME = "methodresolver";
    private static BasicExtensionFactory<AbstractDTExternalContextFactory> _externalContextResolverFactory;
    private static final String EXTERNAL_CONTEXT_EXT_POINT_NAME = "externalcontext";
    private static final String EXTERNAL_CONTEXT_ELEMENT_NAME = "externalcontext";
    private static BasicExtensionFactory<AbstractDTViewHandler> _viewHandlerFactory;
    private static final String VIEWHANDLER_EXT_POINT_NAME = "viewhandler";
    private static final String VIEWHANDLER_ELEMENT_NAME = "viewhandler";
    private static final String VIEWHANDLEROVERRIDE_EXT_POINT_NAME = "viewHandlerOverride";

    public JSFCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IStructuredDocumentContextResolverFactory2 factory = IStructuredDocumentContextResolverFactory2.INSTANCE;
        if (factory instanceof IDelegatingFactory) {
            this._tagLibResolverFactory = new ViewBasedTaglibResolverFactory();
            ((IDelegatingFactory)factory).addFactoryDelegate((IAdaptable)this._tagLibResolverFactory);
        } else {
            JSFCorePlugin.log("Error adding tag resolver delegate", new Throwable());
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IStructuredDocumentContextResolverFactory2 factory = IStructuredDocumentContextResolverFactory2.INSTANCE;
        if (factory instanceof IDelegatingFactory && this._tagLibResolverFactory != null) {
            ((IDelegatingFactory)factory).removeFactoryDelegate((IAdaptable)this._tagLibResolverFactory);
        }
        plugin = null;
    }

    public static JSFCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, String msg) {
        ILog log;
        Status logStatus = new Status(4, PLUGIN_ID, 0, msg, (Throwable)e);
        JSFCorePlugin currentPlugin = JSFCorePlugin.getDefault();
        if (currentPlugin != null && (log = currentPlugin.getLog()) != null) {
            log.log((IStatus)logStatus);
        }
        System.err.println(logStatus);
    }

    public static void log(int severity, String message, Throwable ex) {
        ILog log;
        Status logObject = new Status(severity, PLUGIN_ID, 0, message, ex);
        JSFCorePlugin default1 = JSFCorePlugin.getDefault();
        if (default1 != null && (log = default1.getLog()) != null) {
            log.log((IStatus)logObject);
            return;
        }
        System.err.println(logObject.toString());
    }

    public static void log(int severity, String message) {
        JSFCorePlugin.log(severity, message, null);
    }

    public static void log(String message, Throwable t) {
        ILog log = plugin.getLog();
        log.log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, t));
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static synchronized BasicExtensionFactory.ExtensionData<AbstractDTVariableResolver> getVariableResolvers(String id) {
        JSFCorePlugin.checkAndInitVariableResolverFactory();
        return _variableResolverFactory.getExtensions().get(id);
    }

    public static synchronized List<String> getVariableResolversForName(String forName) {
        JSFCorePlugin.checkAndInitVariableResolverFactory();
        return Collections.unmodifiableList(_variableResolverFactory.getIdsForName(forName));
    }

    public static synchronized boolean hasDecorativeVariableResolvers() {
        JSFCorePlugin.checkAndInitVariableResolverFactory();
        return _variableResolverFactory.getNumDecorativeResolvers() > 0;
    }

    private static synchronized void checkAndInitVariableResolverFactory() {
        if (_variableResolverFactory == null) {
            _variableResolverFactory = new DecoratableExtensionFactory(JSFCorePlugin.getDefault().getBundle(), "variableresolver", "variableresolver", false);
        }
    }

    public static synchronized BasicExtensionFactory.ExtensionData<AbstractDTPropertyResolver> getPropertyResolver(String id) {
        JSFCorePlugin.checkAndInitPropertyFactory();
        return _propertyResolverFactory.getExtensions().get(id);
    }

    private static synchronized void checkAndInitPropertyFactory() {
        if (_propertyResolverFactory == null) {
            _propertyResolverFactory = new DecoratableExtensionFactory(JSFCorePlugin.getDefault().getBundle(), "propertyresolver", "propertyresolver", false);
        }
    }

    public static synchronized List<String> getPropertyResolversForName(String forName) {
        JSFCorePlugin.checkAndInitVariableResolverFactory();
        return Collections.unmodifiableList(_propertyResolverFactory.getIdsForName(forName));
    }

    public static synchronized boolean hasDecorativePropertyResolvers() {
        JSFCorePlugin.checkAndInitVariableResolverFactory();
        return _propertyResolverFactory.getNumDecorativeResolvers() > 0;
    }

    public static synchronized BasicExtensionFactory.ExtensionData<AbstractDTMethodResolver> getMethodResolvers(String id) {
        JSFCorePlugin.checkAndInitMethodResolverFactory();
        return _methodResolverFactory.getExtensions().get(id);
    }

    private static synchronized void checkAndInitMethodResolverFactory() {
        if (_methodResolverFactory == null) {
            _methodResolverFactory = new BasicExtensionFactory(JSFCorePlugin.getDefault().getBundle(), "methodresolver", "methodresolver", false);
        }
    }

    public static synchronized BasicExtensionFactory.ExtensionData<AbstractDTExternalContextFactory> getExternalContextProviders(String id) {
        JSFCorePlugin.checkAndInitExternalContextFactory();
        return _externalContextResolverFactory.getExtensions().get(id);
    }

    private static synchronized void checkAndInitExternalContextFactory() {
        if (_externalContextResolverFactory == null) {
            _externalContextResolverFactory = new BasicExtensionFactory(JSFCorePlugin.getDefault().getBundle(), "externalcontext", "externalcontext", false);
        }
    }

    public static synchronized BasicExtensionFactory.ExtensionData<AbstractDTViewHandler> getViewHandlers(String id) {
        JSFCorePlugin.checkAndInitViewHandler();
        return _viewHandlerFactory.getExtensions().get(id);
    }

    private static synchronized void checkAndInitViewHandler() {
        if (_viewHandlerFactory == null) {
            _viewHandlerFactory = new BasicExtensionFactory(JSFCorePlugin.getDefault().getBundle(), "viewhandler", "viewhandler", true);
        }
    }

    public static synchronized AbstractDTViewHandler getViewOverrideHandler(AbstractDTViewHandler viewHandler) {
        IExtensionPoint extension = JSFCorePlugin.getDefault().getExtension(VIEWHANDLEROVERRIDE_EXT_POINT_NAME);
        if (extension != null) {
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            if (configurationElements.length > 1) {
                JSFCorePlugin.log(4, "More than one view handler override registered");
                return null;
            }
            if (configurationElements.length == 1) {
                try {
                    return (AbstractDTViewHandler)configurationElements[0].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    JSFCorePlugin.log("Failed to load class for view override", e);
                }
            }
        }
        return null;
    }

    public synchronized IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public IExtensionPoint getExtension(String name) {
        return Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), name);
    }
}

