/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.site.SiteLabelProvider;

public class SiteOutlinePage
extends FormOutlinePage {
    private LabelProvider fLabelProvider;

    public SiteOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    protected Object[] getChildren(Object parent) {
        ISiteCategoryDefinition catDef;
        ISiteModel model;
        PDEFormPage page;
        ISiteModel model2;
        if (parent instanceof PDEFormPage && (model2 = (ISiteModel)(page = (PDEFormPage)((Object)parent)).getModel()) != null && model2.isValid()) {
            ISite site = model2.getSite();
            if (page.getId().equals("features")) {
                ISiteFeature[] features;
                ArrayList<SiteFeatureAdapter> result = new ArrayList<SiteFeatureAdapter>();
                ISiteCategoryDefinition[] catDefs = site.getCategoryDefinitions();
                Collections.addAll(result, catDefs);
                ISiteFeature[] iSiteFeatureArray = features = site.getFeatures();
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteFeature feature = iSiteFeatureArray[n2];
                    if (feature.getCategories().length == 0) {
                        result.add(new SiteFeatureAdapter(null, feature));
                    }
                    ++n2;
                }
                return result.toArray();
            }
            if (page.getId().equals("archives")) {
                return site.getArchives();
            }
        }
        if (parent instanceof ISiteCategoryDefinition && (model = (catDef = (ISiteCategoryDefinition)parent).getModel()).isValid()) {
            ISite site = model.getSite();
            ISiteFeature[] features = site.getFeatures();
            HashSet<SiteFeatureAdapter> result = new HashSet<SiteFeatureAdapter>();
            ISiteFeature[] iSiteFeatureArray = features;
            int n = features.length;
            int n3 = 0;
            while (n3 < n) {
                ISiteCategory[] cats;
                ISiteFeature feature = iSiteFeatureArray[n3];
                ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                int n4 = cats.length;
                int n5 = 0;
                while (n5 < n4) {
                    ISiteCategory cat = iSiteCategoryArray[n5];
                    if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                        result.add(new SiteFeatureAdapter(cat.getName(), feature));
                    }
                    ++n5;
                }
                ++n3;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ISiteCategoryDefinition || item instanceof SiteFeatureAdapter) {
            pageId = "features";
        } else if (item instanceof ISiteArchive) {
            pageId = "archives";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    @Override
    public ILabelProvider createLabelProvider() {
        this.fLabelProvider = new SiteLabelProvider();
        return this.fLabelProvider;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

