/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringButtonDialogField
extends StringDialogField {
    private Button _browseButton;
    private String _browseButtonLabel;
    private IStringButtonAdapter _stringButtonAdapter;
    private boolean _buttonEnabled;

    public StringButtonDialogField(IStringButtonAdapter adapter) {
        this._stringButtonAdapter = adapter;
        this._browseButtonLabel = JSFUICommonPlugin.getResourceString("DialogField.Browse");
        this._buttonEnabled = true;
    }

    public void setButtonLabel(String label) {
        this._browseButtonLabel = label;
    }

    public void changeControlPressed() {
        this._stringButtonAdapter.changeControlPressed(this);
    }

    @Override
    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(toolkit, parent);
        text.setLayoutData((Object)StringButtonDialogField.gridDataForText(nColumns - 3));
        Button button = this.getChangeControl(toolkit, parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(toolkit, button, text, 1));
        return new Control[]{requiredLabel, label, text, button};
    }

    @Override
    public int getNumberOfControls() {
        return 4;
    }

    protected static GridData gridDataForButton(FormToolkit toolkit, Button button, Text text, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = LayoutUtil.getButtonWidthHint(button);
        gd.heightHint = LayoutUtil.getButtonHeightHint(toolkit, text);
        return gd;
    }

    public Button getChangeControl(FormToolkit toolkit, Composite parent) {
        if (this._browseButton == null || this._browseButton.isDisposed()) {
            this.assertCompositeNotNull(parent);
            if (toolkit != null) {
                this._browseButton = toolkit.createButton(parent, this._browseButtonLabel, 8);
            } else {
                this._browseButton = new Button(parent, 8);
                this._browseButton.setText(this._browseButtonLabel);
            }
            this._browseButton.setEnabled(this.isEnabled() && this._buttonEnabled);
            this._browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this._browseButton;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this._browseButton)) {
            this._browseButton.setEnabled(this.isEnabled() && enable);
        }
        this._buttonEnabled = enable;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this._browseButton)) {
            this._browseButton.setEnabled(this.isEnabled() && this._buttonEnabled);
        }
    }

    public IStringButtonAdapter getStringButtonAdapter() {
        return this._stringButtonAdapter;
    }

    public void setStringButtonAdapter(IStringButtonAdapter buttonAdapter) {
        this._stringButtonAdapter = buttonAdapter;
    }
}

