/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IScriptLanguageProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.BrowserInformationControl;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.internal.ui.actions.refactoring.RefactorActionGroup;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.GotoMatchingBracketAction;
import org.eclipse.dltk.internal.ui.editor.ISavePolicy;
import org.eclipse.dltk.internal.ui.editor.IScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.OccurrencesFinder;
import org.eclipse.dltk.internal.ui.editor.ScriptAnnotationIterator;
import org.eclipse.dltk.internal.ui.editor.ScriptEditorErrorTickUpdater;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.editor.ScriptTemplatesPage;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.ToggleCommentAction;
import org.eclipse.dltk.internal.ui.editor.selectionaction.GoToNextPreviousMemberAction;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingManager;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingReconciler;
import org.eclipse.dltk.internal.ui.text.DLTKWordIterator;
import org.eclipse.dltk.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.IScriptReconcilingListener;
import org.eclipse.dltk.internal.ui.text.hover.ScriptExpandHover;
import org.eclipse.dltk.internal.ui.text.hover.SourceViewerInformationControl;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.EclipsePreferencesAdapter;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.PreferencesAdapter;
import org.eclipse.dltk.ui.actions.GenerateActionGroup;
import org.eclipse.dltk.ui.actions.OpenEditorActionGroup;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.ui.actions.SearchActionGroup;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.FoldingProviderManager;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class ScriptEditor
extends AbstractDecoratedTextEditor
implements IScriptReconcilingListener,
IScriptLanguageProvider,
IScriptEditor {
    protected ISavePolicy fSavePolicy = null;
    protected static final String MATCHING_BRACKETS = "editor.matching_brackets";
    protected static final String MATCHING_BRACKETS_COLOR = "editor.matching_brackets_color";
    private ScriptEditorErrorTickUpdater fScriptEditorErrorTickUpdater;
    private OccurrencesFinder occurrencesFinder;
    private static String[] GLOBAL_FOLDING_PROPERTIES = new String[]{"editor_folding_enabled", "editor_comments_folding_enabled", "editor_folding_lines_limit", "editor_comments_folding_join_newlines"};
    public static final int CONTENTASSIST_COMPLETE_PREFIX = 60;
    private ScriptOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    private IFoldingStructureProvider fProjectionModelUpdater;
    private ActionGroup fFoldingGroup;
    private InformationPresenter fInformationPresenter;
    private CompositeActionGroup fContextMenuGroup;
    private CompositeActionGroup fActionGroups;
    private AbstractSelectionChangedListener fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private static final String EXTENSION_EDITOR_CONTEXT_ACTION_GROUPS = "editorContextActionGroup";
    private static final String ATTR_NATURE = "nature";
    private static final String ATTR_CLASS = "class";
    private ScriptTemplatesPage fTemplatesPage;
    private ToggleFoldingRunner fFoldingRunner;
    private boolean fSelectionChangedViaGotoAnnotation;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private ICharacterPairMatcher fBracketMatcher;
    private ListenerList<IScriptReconcilingListener> fReconcilingListeners = new ListenerList(1);
    private final Object fReconcilerLock = new Object();
    private SemanticHighlightingManager fSemanticManager;

    public ISourceViewer getScriptSourceViewer() {
        return super.getSourceViewer();
    }

    public ScriptEditor() {
        this.setDocumentProvider(DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider());
        this.fScriptEditorErrorTickUpdater = new ScriptEditorErrorTickUpdater(this);
    }

    protected void handleElementContentReplaced() {
        super.handleElementContentReplaced();
        IAnnotationModel annotationModel = this.getScriptSourceViewer().getAnnotationModel();
        if (annotationModel instanceof IPersistableAnnotationModel) {
            try {
                ((IPersistableAnnotationModel)annotationModel).reinitialize(this.getScriptSourceViewer().getDocument());
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void dispose() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.occurrencesFinder != null) {
            this.occurrencesFinder.dispose();
            this.occurrencesFinder = null;
        }
        if (this.fScriptEditorErrorTickUpdater != null) {
            this.fScriptEditorErrorTickUpdater.dispose();
            this.fScriptEditorErrorTickUpdater = null;
        }
        this.uninstallSemanticHighlighting();
        super.dispose();
    }

    protected void initializeEditor() {
        this.occurrencesFinder = new OccurrencesFinder(this);
        if (!this.occurrencesFinder.isValid()) {
            this.occurrencesFinder = null;
        }
        IPreferenceStore store = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(store);
        ScriptTextTools textTools = this.getTextTools();
        if (textTools != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)textTools.createSourceViewerConfiguraton(store, (ITextEditor)this));
        }
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(8);
        IScriptProject project = EditorUtility.getScriptProject(input);
        IDLTKLanguageToolkit toolkit = this.getLanguageToolkit();
        String preferenceQualifier = toolkit.getPreferenceQualifier();
        if (project != null) {
            if (preferenceQualifier != null) {
                stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), preferenceQualifier));
            }
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.eclipse.dltk.core"));
        }
        stores.add(this.getScriptPreferenceStore());
        if (preferenceQualifier != null) {
            stores.add(new EclipsePreferencesAdapter(InstanceScope.INSTANCE, preferenceQualifier));
            stores.add(new EclipsePreferencesAdapter(DefaultScope.INSTANCE, preferenceQualifier));
        }
        stores.add(new PreferencesAdapter(DLTKCore.getDefault().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        stores.add(PlatformUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public IPreferenceStore getScriptPreferenceStore() {
        IDLTKUILanguageToolkit uiToolkit;
        IDLTKLanguageToolkit toolkit = this.getLanguageToolkit();
        if (toolkit != null && (uiToolkit = DLTKUILanguageManager.getLanguageToolkit(toolkit.getNatureId())) != null) {
            return uiToolkit.getPreferenceStore();
        }
        return null;
    }

    public ScriptTextTools getTextTools() {
        return null;
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
    }

    protected void internalDoSetInput(IEditorInput input) throws CoreException {
        IReconciler reconciler;
        ISourceViewer sourceViewer = this.getSourceViewer();
        ScriptSourceViewer scriptSourceViewer = null;
        if (sourceViewer instanceof ScriptSourceViewer) {
            scriptSourceViewer = (ScriptSourceViewer)sourceViewer;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (scriptSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.dltk.ui.editor.showSegments"))) {
            scriptSourceViewer.prepareDelayedProjection();
        }
        super.doSetInput(input);
        IDocumentProvider docProvider = this.getDocumentProvider();
        IAnnotationModel model = docProvider.getAnnotationModel((Object)input);
        if (model instanceof SourceModuleDocumentProvider.SourceModuleAnnotationModel) {
            ((SourceModuleDocumentProvider.SourceModuleAnnotationModel)model).problemFactory = DLTKLanguageManager.getProblemFactory((String)this.getNatureId());
        }
        IDocument doc = docProvider.getDocument((Object)input);
        this.connectPartitioningToElement(input, doc);
        if (scriptSourceViewer != null && scriptSourceViewer.getReconciler() == null && (reconciler = this.getSourceViewerConfiguration().getReconciler((ISourceViewer)scriptSourceViewer)) != null) {
            reconciler.install((ITextViewer)scriptSourceViewer);
            scriptSourceViewer.setReconciler(reconciler);
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add encoding support and overriding indicator support");
        }
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    private boolean isFoldingEnabled() {
        return this.getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        context.setInput((Object)this.getEditorInput());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
        menu.appendToGroup("group.open", this.getAction("org.eclipse.dltk.ui.edit.text.script.show.outline"));
        menu.appendToGroup("group.open", this.getAction("org.eclipse.dltk.ui.edit.text.script.open.hierarchy"));
    }

    protected void createActions() {
        super.createActions();
        OpenEditorActionGroup oeg = new OpenEditorActionGroup(this);
        OpenViewActionGroup ovg = new OpenViewActionGroup(this);
        SearchActionGroup dsg = new SearchActionGroup(this);
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, dsg});
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, dsg});
        this.loadContributedContextActionGroups();
        this.fFoldingGroup = this.createFoldingActionGroup();
        Object action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        TextOperationAction outlineAction = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 51, true);
        outlineAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.show.outline");
        this.setAction("org.eclipse.dltk.ui.edit.text.script.show.outline", (IAction)outlineAction);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.", (ITextEditor)this, 53, true);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.hierarchy");
        this.setAction("org.eclipse.dltk.ui.edit.text.script.open.hierarchy", (IAction)action);
        action = new ContentAssistAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit");
        this.fActionGroups.addGroup(rg);
        this.fContextMenuGroup.addGroup(rg);
        action = GoToNextPreviousMemberAction.newGoToNextMemberAction(this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.goto.next.member");
        this.setAction("GoToNextMember", (IAction)action);
        action = GoToNextPreviousMemberAction.newGoToPreviousMemberAction(this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.goto.previous.member");
        this.setAction("GoToPreviousMember", (IAction)action);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.comment");
        this.setAction("org.eclipse.dltk.ui.actions.Comment", (IAction)action);
        this.markAsStateDependentAction("org.eclipse.dltk.ui.actions.Comment", true);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.uncomment");
        this.setAction("org.eclipse.dltk.ui.actions.Uncomment", (IAction)action);
        this.markAsStateDependentAction("org.eclipse.dltk.ui.actions.Uncomment", true);
        action = new ToggleCommentAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.toggle.comment");
        this.setAction("org.eclipse.dltk.ui.actions.ToggleComment", (IAction)action);
        this.markAsStateDependentAction("org.eclipse.dltk.ui.actions.ToggleComment", true);
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        ((ToggleCommentAction)((Object)action)).configure(sourceViewer, configuration);
        ActionGroup generateActions = this.createGenerateActionGroup();
        if (generateActions != null) {
            this.fActionGroups.addGroup(generateActions);
            this.fContextMenuGroup.addGroup(generateActions);
        }
    }

    protected ActionGroup createGenerateActionGroup() {
        return new GenerateActionGroup(this, "group.edit");
    }

    private void loadContributedContextActionGroups() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.ui", EXTENSION_EDITOR_CONTEXT_ACTION_GROUPS);
        String natureId = this.getNatureId();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementNature = element.getAttribute(ATTR_NATURE);
            if (elementNature == null || elementNature.equals(natureId)) {
                try {
                    Object actionGroup = element.createExecutableExtension(ATTR_CLASS);
                    if (actionGroup instanceof ActionGroup) {
                        this.fContextMenuGroup.addGroup((ActionGroup)actionGroup);
                    } else {
                        DLTKUIPlugin.logErrorMessage(actionGroup.getClass().getName() + " should extend ActionGroup");
                    }
                }
                catch (CoreException e) {
                    DLTKUIPlugin.log(e);
                }
            }
            ++i;
        }
    }

    protected ActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), this.getScriptPreferenceStore());
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (!this.getPreferenceStore().getBoolean("editor_annotation_roll_over")) {
            return super.createAnnotationRulerColumn(ruler);
        }
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        column.setHover((IAnnotationHover)new ScriptExpandHover(ruler, this.getAnnotationAccess(), new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                this.triggerAction("RulerDoubleClick");
            }

            private void triggerAction(String actionID) {
                IAction action = ScriptEditor.this.getAction(actionID);
                if (action != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (action instanceof ISelectionListener) {
                        ((ISelectionListener)action).selectionChanged(null, null);
                    }
                    if (action.isEnabled()) {
                        action.run();
                    }
                }
            }
        }));
        return column;
    }

    ActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (!(sourceViewer instanceof ISourceViewerExtension2)) {
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            try {
                this.internalDoSetInput(input);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
                this.close(false);
            }
        } else {
            this.getSourceViewerDecorationSupport(sourceViewer).uninstall();
            ((ISourceViewerExtension2)sourceViewer).unconfigure();
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            sourceViewer.configure(this.getSourceViewerConfiguration());
            this.getSourceViewerDecorationSupport(sourceViewer).install(this.getPreferenceStore());
            try {
                this.internalDoSetInput(input);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
                this.close(false);
            }
        }
        if (this.fScriptEditorErrorTickUpdater != null) {
            this.fScriptEditorErrorTickUpdater.updateEditorImage(this.getInputModelElement());
        }
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        ScriptTextTools textTools;
        super.setPreferenceStore(store);
        SourceViewerConfiguration svConfiguration = this.getSourceViewerConfiguration();
        if ((svConfiguration == null || svConfiguration instanceof ScriptSourceViewerConfiguration) && (textTools = this.getTextTools()) != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)textTools.createSourceViewerConfiguraton(store, (ITextEditor)this));
        }
        if (this.getSourceViewer() instanceof ScriptSourceViewer) {
            ((ScriptSourceViewer)this.getSourceViewer()).setPreferenceStore(store);
        }
        if (this.occurrencesFinder != null) {
            this.occurrencesFinder.setPreferenceStore(store);
        }
    }

    private ScriptOutlinePage createOutlinePage() {
        ScriptOutlinePage page = this.doCreateOutlinePage();
        this.fOutlineSelectionChangedListener.install((ISelectionProvider)page);
        this.setOutlinePageInput(page, this.getEditorInput());
        return page;
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new ScriptOutlinePage(this, this.getPreferenceStore());
    }

    public abstract String getEditorId();

    @Override
    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    private void setOutlinePageInput(ScriptOutlinePage page, IEditorInput input) {
        if (page == null) {
            return;
        }
        IModelElement me = this.getInputModelElement();
        if (me != null && me.exists()) {
            page.setInput(me);
        } else {
            page.setInput(null);
        }
    }

    protected ScriptTemplatesPage createTemplatesPage() {
        IDLTKUILanguageToolkit uiToolkit = this.getUILanguageToolkit();
        if (uiToolkit == null) {
            return null;
        }
        ITemplateAccess templateAccess = uiToolkit.getEditorTemplates();
        if (templateAccess == null) {
            return null;
        }
        try {
            return new ScriptTemplatesPage(this, templateAccess);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (ITemplatesPage.class.equals(required)) {
            if (this.fTemplatesPage == null) {
                this.fTemplatesPage = this.createTemplatesPage();
            }
            return (T)((Object)this.fTemplatesPage);
        }
        if (IContentOutlinePage.class.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return (T)((Object)this.fOutlinePage);
        }
        if (required == IShowInTargetList.class) {
            return (T)((IShowInTargetList)() -> new String[]{"org.eclipse.dltk.ui.ScriptExplorer", "org.eclipse.ui.views.ContentOutline"});
        }
        if (required == OccurrencesFinder.class) {
            return (T)this.occurrencesFinder;
        }
        if (required == IFoldingStructureProvider.class) {
            return (T)this.fProjectionModelUpdater;
        }
        if (required == IFoldingStructureProviderExtension.class) {
            return (T)this.fProjectionModelUpdater;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return (T)adapter;
        }
        return (T)super.getAdapter(required);
    }

    public Object getReconcilerLock() {
        return this.fReconcilerLock;
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        ISourceReference reference = null;
        IStructuredSelection selection = event.getStructuredSelection();
        for (Object o : selection) {
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && DLTKUIPlugin.getActivePage() != null) {
            DLTKUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(reference, !this.isActivePart());
        if (this.occurrencesFinder != null) {
            this.occurrencesFinder.updateOccurrenceAnnotations();
        }
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block24: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    ISourceRange range = null;
                    range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember) {
                        range = ((IMember)reference).getNameRange();
                        if (range != null) {
                            offset = range.getOffset();
                            length = range.getLength();
                        }
                    } else if (reference instanceof ILocalVariable) {
                        range = ((ILocalVariable)reference).getNameRange();
                        if (range != null) {
                            offset = range.getOffset();
                            length = range.getLength();
                        }
                    } else if (reference instanceof IImportDeclaration || reference instanceof IPackageDeclaration) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block24;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (ModelException modelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    @Override
    public void setSelection(IModelElement element) {
        if (element == null || element instanceof ISourceModule) {
            return;
        }
        IModelElement corresponding = this.getCorrespondingElement(element);
        if (corresponding instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)corresponding;
            this.setSelection(reference, true);
            if (this.fOutlinePage != null) {
                this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
                this.fOutlinePage.select(reference);
                this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
            }
        }
    }

    protected void synchronizeOutlinePage(ISourceReference element) {
        this.synchronizeOutlinePage(element, true);
    }

    @Override
    public void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || element == null || checkIfOutlinePageActive && this.isOutlinePageActive())) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage.select(element);
            this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
        }
    }

    public void synchronizeOutlinePageSelection() {
        this.synchronizeOutlinePage(this.computeHighlightRangeSourceReference());
    }

    private boolean isOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    protected Annotation findAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        ScriptAnnotationIterator e = new ScriptAnnotationIterator(model, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a instanceof IScriptAnnotation && ((IScriptAnnotation)a).hasOverlay() || !this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        ScriptAnnotationIterator e = new ScriptAnnotationIterator(model, false);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    public Annotation gotoAnnotation(boolean forward) {
        this.fSelectionChangedViaGotoAnnotation = true;
        return super.gotoAnnotation(forward);
    }

    @Override
    public ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IModelElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)element;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IInformationControlCreator informationControlCreator = shell -> {
            boolean cutDown = false;
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                return new BrowserInformationControl(shell, "org.eclipse.jface.dialogfont", true);
            }
            return new DefaultInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.fInformationPresenter.setDocumentPartitioning("__dftl_partition_content_type");
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        this.installSemanticHighlighting();
        if (!this.isEditable()) {
            this.updateSemanticHighlighting();
        }
        if (this.occurrencesFinder != null) {
            this.occurrencesFinder.install();
        }
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISourceReference element = this.computeHighlightRangeSourceReference();
        if (this.getPreferenceStore().getBoolean("syncOutlineOnCursorMove")) {
            this.synchronizeOutlinePage(element);
        }
        this.setSelection(element, false);
        if (!this.fSelectionChangedViaGotoAnnotation) {
            this.updateStatusLine();
        }
        this.fSelectionChangedViaGotoAnnotation = false;
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (annotation instanceof IScriptAnnotation && ((IScriptAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    public IModelElement getInputModelElement() {
        return EditorUtility.getEditorInputModelElement((IEditorPart)this, false);
    }

    protected IModelElement getCorrespondingElement(IModelElement element) {
        return element;
    }

    @Override
    public IModelElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    public IModelElement getElementAt(int offset, boolean reconcile) {
        block5: {
            ISourceModule unit = (ISourceModule)this.getInputModelElement();
            if (unit != null) {
                try {
                    if (reconcile) {
                        ScriptModelUtil.reconcile((ISourceModule)unit);
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (ModelException x) {
                    if (x.isDoesNotExist()) break block5;
                    System.err.println(x.getStatus());
                }
            }
        }
        return null;
    }

    protected IFoldingStructureProvider createFoldingStructureProvider() {
        return FoldingProviderManager.getStructureProvider(this.getNatureId());
    }

    private boolean isEditorHoverProperty(String property) {
        return "hoverModifiers".equals(property);
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        try {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (this.isEditorHoverProperty(property)) {
                this.updateHoverBehavior();
            }
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if ("syncOutlineOnCursorMove".equals(property)) {
                if (newBooleanValue) {
                    this.selectionChanged();
                }
                return;
            }
            if (this.occurrencesFinder != null && this.occurrencesFinder.handlePreferenceStoreChanged(property, newBooleanValue)) {
                return;
            }
            if ("formatter.tabulation.size".equals(property) || "formatter.indentation.size".equals(property) || "formatter.tabulation.char".equals(property)) {
                if ("formatter.tabulation.char".equals(property)) {
                    if (this.isTabsToSpacesConversionEnabled()) {
                        this.installTabsToSpacesConverter();
                    } else {
                        this.uninstallTabsToSpacesConverter();
                    }
                }
                this.updateIndentPrefixes();
                StyledText textWidget = sourceViewer.getTextWidget();
                int tabWidth = this.getSourceViewerConfiguration().getTabWidth(sourceViewer);
                if (textWidget.getTabs() != tabWidth) {
                    textWidget.setTabs(tabWidth);
                }
                return;
            }
            if ("smart_tab".equals(property)) {
                if (this.getPreferenceStore().getBoolean("smart_tab")) {
                    this.setActionActivationCode("org.eclipse.dltk.ui.actions.IndentOnTab", '\t', -1, 0);
                } else {
                    this.removeActionActivationCode("org.eclipse.dltk.ui.actions.IndentOnTab");
                }
            }
            if (this.isFoldingPropertyEvent(property) && sourceViewer instanceof ProjectionViewer) {
                this.handleFoldingPropertyEvent(property);
            }
            ScriptSourceViewerConfiguration ssvc = (ScriptSourceViewerConfiguration)this.getSourceViewerConfiguration();
            IContentAssistant c = ((AdaptedSourceViewer)sourceViewer).getContentAssistant();
            if (c instanceof ContentAssistant) {
                ssvc.changeContentAssistantConfiguration((ContentAssistant)c, event);
            }
            ssvc.handlePropertyChangeEvent(event);
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
        if ("show_range_indicator".equals(property)) {
            Object newValue = event.getNewValue();
            ISourceViewer viewer = this.getSourceViewer();
            if (newValue != null && viewer != null && Boolean.valueOf(newValue.toString()).booleanValue()) {
                Point selection = viewer.getSelectedRange();
                this.adjustHighlightRange(selection.x, selection.y);
            }
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((ScriptSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected void handleFoldingPropertyEvent(String property) {
        if ("editor_folding_enabled".equals(property)) {
            ToggleFoldingRunner runner = new ToggleFoldingRunner();
            runner.runWhenNextVisible();
        } else {
            this.fProjectionModelUpdater.initialize(false);
        }
    }

    protected final boolean isFoldingPropertyEvent(String property) {
        if (this.isHandledPropertyEvent(property, GLOBAL_FOLDING_PROPERTIES)) {
            return true;
        }
        return this.isHandledPropertyEvent(property, this.getFoldingEventPreferenceKeys());
    }

    protected String[] getFoldingEventPreferenceKeys() {
        return CharOperation.NO_STRINGS;
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
        action = new DeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = new DeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        IPreferenceStore store = this.getPreferenceStore();
        ISourceViewer viewer = this.createScriptSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
        if (DLTKCore.DEBUG) {
            System.err.println("Create help contexts");
        }
        ScriptSourceViewer scriptSourceViewer = null;
        if (viewer instanceof ScriptSourceViewer) {
            scriptSourceViewer = (ScriptSourceViewer)viewer;
        }
        if (scriptSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.eclipse.dltk.ui.editor.showSegments"))) {
            scriptSourceViewer.prepareDelayedProjection();
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)viewer;
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        IDLTKLanguageToolkit toolkit = this.getLanguageToolkit();
        this.fProjectionSupport.setHoverControlCreator(shell -> {
            int shellStyle = 0xC | this.getOrientation();
            String statusFieldText = EditorsUI.getTooltipAffordanceString();
            return new SourceViewerInformationControl(shell, shellStyle, 0, statusFieldText, toolkit);
        });
        this.fProjectionSupport.setInformationPresenterControlCreator(shell -> {
            int shellStyle = 0x14 | this.getOrientation();
            int style = 768;
            return new SourceViewerInformationControl(shell, shellStyle, style, toolkit);
        });
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = this.createFoldingStructureProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer, this.getPreferenceStore());
        }
        this.getSourceViewerDecorationSupport(viewer);
        return viewer;
    }

    protected ISourceViewer createScriptSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new AdaptedSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
    }

    public void resetProjection() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    public void collapseMembers() {
        if (this.fProjectionModelUpdater instanceof IFoldingStructureProviderExtension) {
            IFoldingStructureProviderExtension extension = (IFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseMembers();
        }
    }

    public void collapseComments() {
        if (this.fProjectionModelUpdater instanceof IFoldingStructureProviderExtension) {
            IFoldingStructureProviderExtension extension = (IFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseComments();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(DLTKEditorMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        if (action != null) {
            foldingMenu.add(action);
        }
        if ((action = this.getAction("FoldingExpandAll")) != null) {
            foldingMenu.add(action);
        }
        if ((action = this.getAction("FoldingCollapseAll")) != null) {
            foldingMenu.add(action);
        }
        if ((action = this.getAction("FoldingRestore")) != null) {
            foldingMenu.add(action);
        }
        if ((action = this.getAction("FoldingCollapseMembers")) != null) {
            foldingMenu.add(action);
        }
        if ((action = this.getAction("FoldingCollapseComments")) != null) {
            foldingMenu.add(action);
        }
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer, this.getPreferenceStore());
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    protected String getNatureId() {
        return this.getLanguageToolkit().getNatureId();
    }

    @Override
    public abstract IDLTKLanguageToolkit getLanguageToolkit();

    protected IDLTKUILanguageToolkit getUILanguageToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit(this.getNatureId());
    }

    public String getCallHierarchyID() {
        return null;
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p instanceof ISourceModuleDocumentProvider) {
            ISourceModuleDocumentProvider cp = (ISourceModuleDocumentProvider)p;
            cp.setSavePolicy(this.fSavePolicy);
        }
        try {
            super.performSave(overwrite, progressMonitor);
        }
        finally {
            if (p instanceof ISourceModuleDocumentProvider) {
                ISourceModuleDocumentProvider cp = (ISourceModuleDocumentProvider)p;
                cp.setSavePolicy(null);
            }
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)DLTKEditorMessages.SourceModuleEditor_error_saving_title1, (String)DLTKEditorMessages.SourceModuleEditor_error_saving_message1);
            }
        } else {
            this.setStatusLineErrorMessage(null);
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
            ISourceModule unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                this.performSave(false, progressMonitor);
            } else {
                this.performSave(false, progressMonitor);
            }
        }
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = ScriptEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    protected static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return ScriptEditor.isBracket(document.getChar(offset - 1)) && ScriptEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    protected final ICharacterPairMatcher getBracketMatcher() {
        if (this.fBracketMatcher == null) {
            this.fBracketMatcher = this.createBracketMatcher();
        }
        return this.fBracketMatcher;
    }

    protected ICharacterPairMatcher createBracketMatcher() {
        return null;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.configureBracketMatcher(support);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void configureBracketMatcher(SourceViewerDecorationSupport support) {
        ICharacterPairMatcher bracketMatcher = this.getBracketMatcher();
        if (bracketMatcher != null) {
            support.setCharacterPairMatcher(bracketMatcher);
            support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        }
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ICharacterPairMatcher bracketMatcher = this.getBracketMatcher();
        if (bracketMatcher == null) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(DLTKEditorMessages.ScriptEditor_nobracketSelected);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (ScriptEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = bracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(DLTKEditorMessages.ScriptEditor_noMatchingBracketFound);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = bracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(DLTKEditorMessages.ScriptEditor_matchingBracketIsOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    @Override
    public void aboutToBeReconciled() {
        for (IScriptReconcilingListener listener : this.fReconcilingListeners) {
            listener.aboutToBeReconciled();
        }
    }

    @Override
    public void reconciled(ISourceModule ast, boolean forced, IProgressMonitor progressMonitor) {
        Shell shell;
        for (IScriptReconcilingListener listener : this.fReconcilingListeners) {
            listener.reconciled(ast, forced, progressMonitor);
        }
        if (!(forced || progressMonitor.isCanceled() || (shell = this.getSite().getShell()) == null || shell.isDisposed())) {
            shell.getDisplay().asyncExec(() -> this.selectionChanged());
        }
    }

    public void addReconcileListener(IScriptReconcilingListener semanticHighlightingReconciler) {
        this.fReconcilingListeners.add((Object)semanticHighlightingReconciler);
    }

    public void removeReconcileListener(IScriptReconcilingListener semanticHighlightingReconciler) {
        this.fReconcilingListeners.remove((Object)semanticHighlightingReconciler);
    }

    private void installSemanticHighlighting() {
        ISemanticHighlightingUpdater updater;
        ScriptTextTools textTools = this.getTextTools();
        if (this.fSemanticManager == null && textTools != null && (updater = textTools.getSemanticPositionUpdater(this.getNatureId())) != null) {
            this.fSemanticManager = new SemanticHighlightingManager(updater);
            this.fSemanticManager.install(this, (ScriptSourceViewer)this.getSourceViewer(), textTools.getColorManager(), this.getPreferenceStore());
        }
    }

    private void updateSemanticHighlighting() {
        final IModelElement element = this.getInputModelElement();
        if (!(element instanceof ISourceModule)) {
            return;
        }
        Job job = new Job(DLTKEditorMessages.ScriptEditor_InitializeSemanticHighlighting){

            protected IStatus run(IProgressMonitor monitor) {
                SemanticHighlightingReconciler reconciler;
                if (ScriptEditor.this.fSemanticManager != null && (reconciler = ScriptEditor.this.fSemanticManager.getReconciler()) != null) {
                    reconciler.reconciled((ISourceModule)element, false, monitor);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setSystem(true);
        job.schedule();
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticManager != null) {
            this.fSemanticManager.uninstall();
            this.fSemanticManager = null;
        }
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> result = new ArrayList<String>();
        IDLTKUILanguageToolkit uiToolkit = this.getUILanguageToolkit();
        this.addPages(result, uiToolkit.getEditorPreferencePages());
        this.addPages(result, super.collectContextMenuPreferencePages());
        return result.toArray(new String[result.size()]);
    }

    private void addPages(List<String> result, String[] pages) {
        if (pages != null) {
            int i = 0;
            while (i < pages.length) {
                if (!result.contains(pages[i])) {
                    result.add(pages[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return this.getPreferenceStore() != null && "space".equals(this.getPreferenceStore().getString("formatter.tabulation.char"));
    }

    private boolean isHandledPropertyEvent(String property, String[] handled) {
        int i = 0;
        while (i < handled.length) {
            if (handled[i].equals(property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getSymbolicFontName() {
        return this.getFontPropertyPreferenceKey();
    }

    protected IProgressMonitor getProgressMonitor() {
        return super.getProgressMonitor();
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    class AdaptedSourceViewer
    extends ScriptSourceViewer
    implements ICompletionListener {
        private List<ITextConverter> fTextConverters;
        private boolean fIgnoreTextConverters;
        private boolean fInCompletionSession;

        protected IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
            this.fIgnoreTextConverters = false;
        }

        @Override
        public void configure(SourceViewerConfiguration configuration) {
            super.configure(configuration);
            IContentAssistant ca = this.getContentAssistant();
            if (ca instanceof IContentAssistantExtension2) {
                ((IContentAssistantExtension2)ca).addCompletionListener((ICompletionListener)this);
            }
        }

        @Override
        public void unconfigure() {
            IContentAssistant ca = this.getContentAssistant();
            if (ca instanceof IContentAssistantExtension2) {
                ((IContentAssistantExtension2)ca).removeCompletionListener((ICompletionListener)this);
            }
            super.unconfigure();
        }

        @Override
        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    ScriptEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 22: {
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    ScriptEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
            }
            super.doOperation(operation);
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList<ITextConverter>(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && this.fTextConverters != null) {
                for (ITextConverter c : this.fTextConverters) {
                    c.customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.fInCompletionSession = false;
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            this.fInCompletionSession = true;
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }

        private IProject getProject() {
            IScriptProject scriptProject;
            IModelElement input = ScriptEditor.this.getInputModelElement();
            if (input != null && (scriptProject = input.getScriptProject()) != null) {
                return scriptProject.getProject();
            }
            return null;
        }

        private ISourceModule getSourceModule() {
            IModelElement input = ScriptEditor.this.getInputModelElement();
            if (input != null) {
                return (ISourceModule)input.getAncestor(5);
            }
            return null;
        }

        public IFormattingContext createFormattingContext() {
            IFormattingContext context = super.createFormattingContext();
            context.setProperty((Object)"formatting.context.sourceModule", (Object)this.getSourceModule());
            IProject project = this.getProject();
            context.setProperty((Object)"formatting.context.project", (Object)project);
            IScriptFormatterFactory factory = ScriptFormatterManager.getSelected(ScriptEditor.this.getLanguageToolkit().getNatureId(), project);
            if (factory != null) {
                context.setProperty((Object)"formatting.context.formatterId", (Object)factory.getId());
                Map<String, String> preferences = factory.retrievePreferences((IPreferencesLookupDelegate)new PreferencesLookupDelegate(project));
                context.setProperty((Object)"formatting.context.preferences", preferences);
            }
            return context;
        }
    }

    public static class BracketLevel {
        public int fOffset;
        public int fLength;
        public LinkedModeUI fUI;
        public Position fFirstPosition;
        public Position fSecondPosition;
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        @Override
        protected void setCaretPosition(int position) {
            int length;
            int caret;
            if (!ScriptEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            Point selection = viewer.getSelectedRange();
            if (selection.y != 0) {
                caret = selection.x;
                length = selection.y;
            } else {
                caret = ScriptEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                length = position - caret;
            }
            try {
                viewer.getDocument().replace(caret, length, "");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        protected int findNextPosition(int position) {
            return this.fIterator.following(position);
        }

        public void update() {
            this.setEnabled(ScriptEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        @Override
        protected void setCaretPosition(int position) {
            int length;
            if (!ScriptEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            Point selection = viewer.getSelectedRange();
            if (selection.y != 0) {
                position = selection.x;
                length = selection.y;
            } else {
                length = ScriptEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset()) - position;
            }
            try {
                viewer.getDocument().replace(position, length, "");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        protected int findPreviousPosition(int position) {
            return this.fIterator.preceding(position);
        }

        public void update() {
            this.setEnabled(ScriptEditor.this.isEditorInputModifiable());
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ScriptEditor.this.selectionChanged();
        }
    }

    static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    public class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        public final char fExitCharacter;
        public final char fEscapeCharacter;
        public final Stack fStack;
        public final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = (BracketLevel)this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    if (((AdaptedSourceViewer)ScriptEditor.this.getScriptSourceViewer()).fInCompletionSession) {
                        return new LinkedModeUI.ExitFlags(0, true);
                    }
                    IDocument document = ScriptEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = ScriptEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)ScriptEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)ScriptEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected DLTKWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(ScriptEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new DLTKWordIterator();
        }

        public void run() {
            IPreferenceStore store = ScriptEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = ScriptEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            if (next != -1) {
                this.setCaretPosition(next);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener {
        OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ScriptEditor.this.doSelectionChanged(event);
        }
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected DLTKWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(ScriptEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new DLTKWordIterator();
        }

        public void run() {
            IPreferenceStore store = ScriptEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = ScriptEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            if (previous != -1) {
                this.setCaretPosition(previous);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = ScriptEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = ScriptEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        private void toggleFolding() {
            ProjectionViewer pv;
            ISourceViewer sourceViewer = ScriptEditor.this.getSourceViewer();
            if (sourceViewer instanceof ProjectionViewer && (pv = (ProjectionViewer)sourceViewer).isProjectionMode() != ScriptEditor.this.isFoldingEnabled() && pv.canDoOperation(19)) {
                pv.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage page;
            if (ScriptEditor.this.fFoldingRunner != null) {
                ScriptEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite site = ScriptEditor.this.getSite();
            if (site != null && !(page = site.getPage()).isPartVisible((IWorkbenchPart)ScriptEditor.this)) {
                this.fPage = page;
                ScriptEditor.this.fFoldingRunner = this;
                page.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (ScriptEditor.this.fFoldingRunner == this) {
                ScriptEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (ScriptEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (ScriptEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

