/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchConfigurationDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class BranchPropertySource
implements IPropertySource {
    static final String EDITACTIONID = "EditBranch";
    private final PropertySheetPage myPage;
    private final Repository myRepository;
    private final String myBranchName;
    private ActionContributionItem editAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchPropertySource(Repository repository, String fullBranchName, PropertySheetPage page) {
        this.myPage = page;
        this.myBranchName = Repository.shortenRefName((String)fullBranchName);
        this.myRepository = repository;
        PropertySheetPage propertySheetPage = this.myPage;
        synchronized (propertySheetPage) {
            IActionBars bars = this.myPage.getSite().getActionBars();
            IToolBarManager mgr = bars.getToolBarManager();
            this.editAction = (ActionContributionItem)mgr.find(EDITACTIONID);
            if (this.editAction != null) {
                ((EditAction)this.editAction.getAction()).setSource(this);
            } else {
                this.editAction = new ActionContributionItem((IAction)new EditAction(UIText.RepositoryPropertySource_EditConfigButton, UIIcons.EDITCONFIG, this));
                mgr.add((IContributionItem)new Separator());
                mgr.add((IContributionItem)this.editAction);
            }
            mgr.update(false);
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> resultList = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor desc = new PropertyDescriptor((Object)"merge", UIText.BranchPropertySource_UpstreamBranchDescriptor);
        desc.setCategory(UIText.BranchPropertySource_UpstreamConfigurationCategory);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"remote", UIText.BranchPropertySource_RemoteDescriptor);
        desc.setCategory(UIText.BranchPropertySource_UpstreamConfigurationCategory);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"pushRemote", UIText.BranchPropertySource_PushRemoteDescriptor);
        desc.setCategory(UIText.BranchPropertySource_UpstreamConfigurationCategory);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)"rebase", UIText.BranchPropertySource_RebaseDescriptor);
        desc.setCategory(UIText.BranchPropertySource_UpstreamConfigurationCategory);
        resultList.add(desc);
        return resultList.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        String actId = (String)id;
        StoredConfig config = this.myRepository.getConfig();
        String value = config.getString("branch", this.myBranchName, actId);
        if (value == null || value.isEmpty()) {
            if ("pushRemote".equals(actId)) {
                value = config.getString("remote", null, "pushDefault");
                String source = null;
                if (value == null) {
                    value = config.getString("branch", this.myBranchName, "remote");
                    if (value != null) {
                        source = UIText.BranchPropertySource_RemoteDescriptor;
                    }
                } else {
                    source = "remote.pushDefault";
                }
                if (value != null) {
                    return MessageFormat.format(UIText.BranchPropertySource_ValueNotSetDefault, source, value);
                }
            }
            return UIText.BranchPropertySource_ValueNotSet;
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static class EditAction
    extends Action {
        private BranchPropertySource source;

        public EditAction(String text, ImageDescriptor image, BranchPropertySource source) {
            super(text, image);
            this.source = source;
        }

        public EditAction setSource(BranchPropertySource source) {
            this.source = source;
            return this;
        }

        public String getId() {
            return BranchPropertySource.EDITACTIONID;
        }

        public void run() {
            new BranchConfigurationDialog(this.source.myPage.getSite().getShell(), this.source.myBranchName, this.source.myRepository).open();
            this.source.myPage.refresh();
        }

        public int getStyle() {
            return 1;
        }
    }
}

