/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerCallTraceLayer;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIConstants;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.views.AbstractTableSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class FunctionInvocationStatisticsView
extends ViewPart {
    private static final String[] fSelectedMethodHeaders = new String[]{PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_0"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_1"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_2"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_3"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_4"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_5")};
    private static final ColumnWeightData[] fSelectedMethodWeights = new ColumnWeightData[]{new ColumnWeightData(100), new ColumnWeightData(150), new ColumnWeightData(200), new ColumnWeightData(170), new ColumnWeightData(130), new ColumnWeightData(130)};
    private static final String[] fInvokeFunctionHeaders = new String[]{PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_6"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_7"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_8"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_9"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_10"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_11"), PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_12")};
    private static final ColumnWeightData[] fInvokeFunctionWeights = new ColumnWeightData[]{new ColumnWeightData(130), new ColumnWeightData(150), new ColumnWeightData(200), new ColumnWeightData(170), new ColumnWeightData(130), new ColumnWeightData(130), new ColumnWeightData(130)};
    private static NumberFormat fNumberFormatter = new DecimalFormat("0.000000");
    private static final Object[] EMPTY_SET = new Object[0];
    private ScrolledForm fForm;
    private TableViewer fSelectedMethodViewer;
    private TableViewer fInvokedByViewer;
    private TableViewer fMethodInvokesViewer;
    private ProfilerDB fProfilerDB;

    public void createPartControl(Composite parent) {
        this.createForm(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.function_invocation_statistics_view");
    }

    private void createForm(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.fForm = toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.fForm.getBody().setLayout((Layout)layout);
        this.createSelectedMethodSection(toolkit);
        this.createInvokedBySection(toolkit);
        this.createInvokesSection(toolkit);
    }

    private void createInvokesSection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fForm.getBody(), -1);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        section.setLayoutData((Object)data);
        section.setText(PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_13"));
        Composite sectionClient = new Composite((Composite)section, 0);
        toolkit.paintBordersFor(sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sectionClient.setLayout((Layout)layout);
        this.fMethodInvokesViewer = new TableViewer(sectionClient, 66306);
        Table table = this.fMethodInvokesViewer.getTable();
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        table.setLayoutData((Object)data);
        int i = 0;
        while (i < fInvokeFunctionHeaders.length) {
            tableLayout.addColumnData((ColumnLayoutData)fInvokeFunctionWeights[i]);
            TableColumn tableColumn = new TableColumn(table, 0, i);
            tableColumn.setText(fInvokeFunctionHeaders[i]);
            tableColumn.setResizable(FunctionInvocationStatisticsView.fInvokeFunctionWeights[i].resizable);
            final int field = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InvokeFunctionSorter sorter = (InvokeFunctionSorter)FunctionInvocationStatisticsView.this.fMethodInvokesViewer.getSorter();
                    sorter.setColumn(field);
                    TableColumn[] tableColumns = FunctionInvocationStatisticsView.this.fMethodInvokesViewer.getTable().getColumns();
                    int i = 0;
                    while (i < fInvokeFunctionHeaders.length) {
                        tableColumns[i].setImage(null);
                        ++i;
                    }
                    if (sorter.getOrder() == ProfilerUIConstants.SORT_ASCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_ASCENDING"));
                    } else if (sorter.getOrder() == ProfilerUIConstants.SORT_DESCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_DESCENDING"));
                    }
                    FunctionInvocationStatisticsView.this.fMethodInvokesViewer.refresh();
                }
            });
        }
        section.setClient((Control)sectionClient);
        toolkit.adapt(sectionClient);
        this.fMethodInvokesViewer.setContentProvider((IContentProvider)new MethodInvokesContentProvider());
        this.fMethodInvokesViewer.setLabelProvider((IBaseLabelProvider)new InvokeFunctionLabelProvider());
        this.fMethodInvokesViewer.setSorter((ViewerSorter)new InvokeFunctionSorter());
    }

    private void createInvokedBySection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fForm.getBody(), -1);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        section.setLayoutData((Object)data);
        section.setText(PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_14"));
        Composite sectionClient = new Composite((Composite)section, 0);
        toolkit.paintBordersFor(sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sectionClient.setLayout((Layout)layout);
        this.fInvokedByViewer = new TableViewer(sectionClient, 66306);
        Table table = this.fInvokedByViewer.getTable();
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        table.setLayoutData((Object)data);
        int i = 0;
        while (i < fInvokeFunctionHeaders.length) {
            tableLayout.addColumnData((ColumnLayoutData)fInvokeFunctionWeights[i]);
            TableColumn tableColumn = new TableColumn(table, 0, i);
            tableColumn.setText(fInvokeFunctionHeaders[i]);
            tableColumn.setResizable(FunctionInvocationStatisticsView.fInvokeFunctionWeights[i].resizable);
            final int field = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InvokeFunctionSorter sorter = (InvokeFunctionSorter)FunctionInvocationStatisticsView.this.fInvokedByViewer.getSorter();
                    sorter.setColumn(field);
                    TableColumn[] tableColumns = FunctionInvocationStatisticsView.this.fInvokedByViewer.getTable().getColumns();
                    int i = 0;
                    while (i < fInvokeFunctionHeaders.length) {
                        tableColumns[i].setImage(null);
                        ++i;
                    }
                    if (sorter.getOrder() == ProfilerUIConstants.SORT_ASCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_ASCENDING"));
                    } else if (sorter.getOrder() == ProfilerUIConstants.SORT_DESCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_DESCENDING"));
                    }
                    FunctionInvocationStatisticsView.this.fInvokedByViewer.refresh();
                }
            });
        }
        section.setClient((Control)sectionClient);
        toolkit.adapt(sectionClient);
        this.fInvokedByViewer.setContentProvider((IContentProvider)new InvokedByContentProvider());
        this.fInvokedByViewer.setLabelProvider((IBaseLabelProvider)new InvokeFunctionLabelProvider());
        this.fInvokedByViewer.setSorter((ViewerSorter)new InvokeFunctionSorter());
    }

    private void createSelectedMethodSection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fForm.getBody(), -1);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        section.setLayoutData((Object)data);
        section.setText(PHPProfileUIMessages.getString("FunctionInvocationStatisticsView_15"));
        Composite sectionClient = new Composite((Composite)section, 0);
        toolkit.paintBordersFor(sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sectionClient.setLayout((Layout)layout);
        this.fSelectedMethodViewer = new TableViewer(sectionClient, 66306);
        Table table = this.fSelectedMethodViewer.getTable();
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        table.setLayoutData((Object)data);
        int i = 0;
        while (i < fSelectedMethodHeaders.length) {
            tableLayout.addColumnData((ColumnLayoutData)fSelectedMethodWeights[i]);
            TableColumn tableColumn = new TableColumn(table, 0, i);
            tableColumn.setText(fSelectedMethodHeaders[i]);
            tableColumn.setResizable(FunctionInvocationStatisticsView.fSelectedMethodWeights[i].resizable);
            final int field = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectedMethodSorter sorter = (SelectedMethodSorter)FunctionInvocationStatisticsView.this.fSelectedMethodViewer.getSorter();
                    sorter.setColumn(field);
                    TableColumn[] tableColumns = FunctionInvocationStatisticsView.this.fSelectedMethodViewer.getTable().getColumns();
                    int i = 0;
                    while (i < fSelectedMethodHeaders.length) {
                        tableColumns[i].setImage(null);
                        ++i;
                    }
                    if (sorter.getOrder() == ProfilerUIConstants.SORT_ASCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_ASCENDING"));
                    } else if (sorter.getOrder() == ProfilerUIConstants.SORT_DESCENDING) {
                        tableColumns[field].setImage(ProfilerUIImages.get("IMG_OBJ_SORT_DESCENDING"));
                    }
                    FunctionInvocationStatisticsView.this.fSelectedMethodViewer.refresh();
                }
            });
        }
        section.setClient((Control)sectionClient);
        toolkit.adapt(sectionClient);
        this.fSelectedMethodViewer.setContentProvider((IContentProvider)new SelectedMethodContentProvider());
        this.fSelectedMethodViewer.setLabelProvider((IBaseLabelProvider)new SelectedMethodLabelProvider());
        this.fSelectedMethodViewer.setSorter((ViewerSorter)new SelectedMethodSorter());
    }

    public void setFocus() {
    }

    public void setInput(ProfilerDB db, ProfilerFunctionData function) {
        this.fProfilerDB = db;
        this.fSelectedMethodViewer.setInput((Object)function);
        this.fInvokedByViewer.setInput((Object)function);
        this.fMethodInvokesViewer.setInput((Object)function);
        this.fForm.reflow(true);
        this.setTitleToolTip(function.toString());
    }

    class InvokeFunctionLabelProvider
    implements ITableLabelProvider {
        private Image fFunctionImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_MISC_PUBLIC);
        private Image fFileImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_CUNIT);

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof InvokeFunctionTableElement) {
                switch (columnIndex) {
                    case 1: {
                        return this.fFunctionImage;
                    }
                    case 2: {
                        return this.fFileImage;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof InvokeFunctionTableElement) {
                InvokeFunctionTableElement invokeFunctionElement = (InvokeFunctionTableElement)element;
                ProfilerFunctionData funcData = invokeFunctionElement.getFunctionData();
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(invokeFunctionElement.getInvokesNumber());
                    }
                    case 1: {
                        return funcData.toString();
                    }
                    case 2: {
                        return funcData.getFileName();
                    }
                    case 3: {
                        if (funcData.getCallsCount() > 0) {
                            return fNumberFormatter.format(funcData.getOwnTime() / (double)funcData.getCallsCount());
                        }
                    }
                    case 4: {
                        return fNumberFormatter.format(funcData.getOwnTime());
                    }
                    case 5: {
                        return fNumberFormatter.format(funcData.getTotalTime());
                    }
                    case 6: {
                        return Integer.toString(funcData.getCallsCount());
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class InvokeFunctionSorter
    extends AbstractTableSorter {
        InvokeFunctionSorter() {
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof InvokeFunctionTableElement && e2 instanceof InvokeFunctionTableElement) {
                InvokeFunctionTableElement i1 = (InvokeFunctionTableElement)e1;
                InvokeFunctionTableElement i2 = (InvokeFunctionTableElement)e2;
                ProfilerFunctionData f1 = i1.getFunctionData();
                ProfilerFunctionData f2 = i2.getFunctionData();
                switch (this.getColumn()) {
                    case 0: {
                        return this.compare(i1.getInvokesNumber(), i2.getInvokesNumber());
                    }
                    case 1: {
                        return super.compare(viewer, f1, f2);
                    }
                    case 2: {
                        return super.compare(viewer, f1.getFileName(), f2.getFileName());
                    }
                    case 3: {
                        if (f1.getCallsCount() > 0 && f2.getCallsCount() > 0) {
                            return this.compare(f1.getOwnTime() / (double)f1.getCallsCount(), f2.getOwnTime() / (double)f2.getCallsCount());
                        }
                    }
                    case 4: {
                        return this.compare(f1.getOwnTime(), f2.getOwnTime());
                    }
                    case 5: {
                        return this.compare(f1.getTotalTime(), f2.getTotalTime());
                    }
                    case 6: {
                        return this.compare(f1.getCallsCount(), f2.getCallsCount());
                    }
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class InvokeFunctionTableElement {
        private ProfilerFunctionData fFunction;
        private int fInvokesNumber;

        public void setFunctionData(ProfilerFunctionData function) {
            this.fFunction = function;
        }

        public ProfilerFunctionData getFunctionData() {
            return this.fFunction;
        }

        public void setInvokesNumber(int invokesNumber) {
            this.fInvokesNumber = invokesNumber;
        }

        public int getInvokesNumber() {
            return this.fInvokesNumber;
        }
    }

    class InvokedByContentProvider
    implements IStructuredContentProvider {
        InvokedByContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ProfilerFunctionData) {
                ProfilerCallTraceLayer[] layers;
                ProfilerFunctionData function = (ProfilerFunctionData)inputElement;
                IntHashtable invokers = new IntHashtable();
                Vector<Integer> callerIDs = new Vector<Integer>();
                ProfilerCallTrace callTrace = FunctionInvocationStatisticsView.this.fProfilerDB.getCallTrace();
                if (callTrace != null && (layers = callTrace.getLayers()).length > 0) {
                    callerIDs.add(layers[0].getCalledID());
                    int i = 1;
                    while (i < layers.length) {
                        if (layers[i].getType() == 0 && callerIDs.size() > 0) {
                            callerIDs.removeElementAt(callerIDs.size() - 1);
                        } else {
                            if (layers[i].getCalledID() == function.getID() && callerIDs.size() > 0) {
                                int id = (Integer)callerIDs.lastElement();
                                if (invokers.containsKey(id)) {
                                    invoker = (InvokeFunctionTableElement)invokers.get(id);
                                    invoker.setInvokesNumber(invoker.getInvokesNumber() + 1);
                                } else {
                                    invoker = new InvokeFunctionTableElement();
                                    invoker.setFunctionData(FunctionInvocationStatisticsView.this.fProfilerDB.getFunctionData(id));
                                    invoker.setInvokesNumber(1);
                                    invokers.put(id, (Object)invoker);
                                }
                            }
                            callerIDs.add(layers[i].getCalledID());
                        }
                        ++i;
                    }
                }
                Object[] elements = new Object[invokers.size()];
                Enumeration e = invokers.elements();
                int i = 0;
                while (e.hasMoreElements()) {
                    elements[i++] = e.nextElement();
                }
                return elements;
            }
            return EMPTY_SET;
        }
    }

    class MethodInvokesContentProvider
    implements IStructuredContentProvider {
        MethodInvokesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ProfilerFunctionData) {
                ProfilerCallTraceLayer[] layers;
                ProfilerFunctionData function = (ProfilerFunctionData)inputElement;
                IntHashtable invokees = new IntHashtable();
                Vector<Integer> callerIDs = new Vector<Integer>();
                ProfilerCallTrace callTrace = FunctionInvocationStatisticsView.this.fProfilerDB.getCallTrace();
                if (callTrace != null && (layers = callTrace.getLayers()).length > 0) {
                    callerIDs.add(layers[0].getCalledID());
                    int i = 1;
                    while (i < layers.length) {
                        if (layers[i].getType() == 0 && callerIDs.size() > 0) {
                            callerIDs.removeElementAt(callerIDs.size() - 1);
                        } else {
                            if (callerIDs.size() > 0 && ((Integer)callerIDs.lastElement()).intValue() == function.getID()) {
                                int id = layers[i].getCalledID();
                                if (invokees.containsKey(id)) {
                                    invokee = (InvokeFunctionTableElement)invokees.get(id);
                                    invokee.setInvokesNumber(invokee.getInvokesNumber() + 1);
                                } else {
                                    invokee = new InvokeFunctionTableElement();
                                    invokee.setFunctionData(FunctionInvocationStatisticsView.this.fProfilerDB.getFunctionData(id));
                                    invokee.setInvokesNumber(1);
                                    invokees.put(id, (Object)invokee);
                                }
                            }
                            callerIDs.add(layers[i].getCalledID());
                        }
                        ++i;
                    }
                }
                Object[] elements = new Object[invokees.size()];
                Enumeration e = invokees.elements();
                int i = 0;
                while (e.hasMoreElements()) {
                    elements[i++] = e.nextElement();
                }
                return elements;
            }
            return EMPTY_SET;
        }
    }

    class SelectedMethodContentProvider
    implements IStructuredContentProvider {
        SelectedMethodContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ProfilerFunctionData) {
                return new Object[]{inputElement};
            }
            return EMPTY_SET;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SelectedMethodLabelProvider
    implements ITableLabelProvider {
        private Image fFunctionImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_MISC_PUBLIC);
        private Image fFileImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_CUNIT);

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ProfilerFunctionData) {
                switch (columnIndex) {
                    case 1: {
                        return this.fFunctionImage;
                    }
                    case 2: {
                        return this.fFileImage;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ProfilerFunctionData) {
                ProfilerFunctionData funcData = (ProfilerFunctionData)element;
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(funcData.getCallsCount());
                    }
                    case 1: {
                        return funcData.toString();
                    }
                    case 2: {
                        return funcData.getFileName();
                    }
                    case 3: {
                        if (funcData.getCallsCount() > 0) {
                            return fNumberFormatter.format(funcData.getOwnTime() / (double)funcData.getCallsCount());
                        }
                    }
                    case 4: {
                        return fNumberFormatter.format(funcData.getOwnTime());
                    }
                    case 5: {
                        return fNumberFormatter.format(funcData.getTotalTime());
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class SelectedMethodSorter
    extends AbstractTableSorter {
        SelectedMethodSorter() {
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ProfilerFunctionData && e2 instanceof ProfilerFunctionData) {
                ProfilerFunctionData f1 = (ProfilerFunctionData)e1;
                ProfilerFunctionData f2 = (ProfilerFunctionData)e2;
                switch (this.getColumn()) {
                    case 0: {
                        return this.compare(f1.getCallsCount(), f2.getCallsCount());
                    }
                    case 2: {
                        return super.compare(viewer, f1.getFileName(), f2.getFileName());
                    }
                    case 3: {
                        if (f1.getCallsCount() > 0 && f2.getCallsCount() > 0) {
                            return this.compare(f1.getOwnTime() / (double)f1.getCallsCount(), f2.getOwnTime() / (double)f2.getCallsCount());
                        }
                    }
                    case 4: {
                        return this.compare(f1.getOwnTime(), f2.getOwnTime());
                    }
                    case 5: {
                        return this.compare(f1.getTotalTime(), f2.getTotalTime());
                    }
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

