/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsKind;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerExeSettings;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerServerSettings;

public class XDebugDebuggerSettingsProvider
extends AbstractDebuggerSettingsProvider {
    @Override
    protected IDebuggerSettings createSettings(DebuggerSettingsKind kind, String ownerId) {
        switch (kind) {
            case PHP_SERVER: {
                return new XDebugDebuggerServerSettings(ownerId);
            }
            case PHP_EXE: {
                return new XDebugDebuggerExeSettings(ownerId);
            }
        }
        return null;
    }

    @Override
    protected IDebuggerSettings createSettings(DebuggerSettingsKind kind, String ownerId, Map<String, String> attributes) {
        switch (kind) {
            case PHP_SERVER: {
                return new XDebugDebuggerServerSettings(ownerId, Collections.unmodifiableMap(attributes));
            }
            case PHP_EXE: {
                return new XDebugDebuggerExeSettings(ownerId, Collections.unmodifiableMap(attributes));
            }
        }
        return null;
    }

    @Override
    public IDebuggerSettingsWorkingCopy createWorkingCopy(IDebuggerSettings settings) {
        switch (settings.getKind()) {
            case PHP_SERVER: {
                return new ServerSettingsWorkingCopy(settings);
            }
            case PHP_EXE: {
                return new ExeSettingsWorkingCopy(settings);
            }
        }
        return null;
    }

    private class ExeSettingsWorkingCopy
    extends XDebugDebuggerExeSettings
    implements IDebuggerSettingsWorkingCopy {
        private IDebuggerSettings original;
        private boolean dirty;

        protected ExeSettingsWorkingCopy(IDebuggerSettings original) {
            super(original.getOwnerId(), new HashMap<String, String>(original.getAttributes()));
            this.dirty = false;
            this.original = original;
        }

        @Override
        public void setAttribute(String key, String value) {
            this.attributes.put(key, value);
            this.dirty = true;
        }

        @Override
        public IDebuggerSettings getOriginal() {
            return this.original;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }
    }

    private class ServerSettingsWorkingCopy
    extends XDebugDebuggerServerSettings
    implements IDebuggerSettingsWorkingCopy {
        private IDebuggerSettings original;
        private boolean dirty;

        protected ServerSettingsWorkingCopy(IDebuggerSettings original) {
            super(original.getOwnerId(), new HashMap<String, String>(original.getAttributes()));
            this.dirty = false;
            this.original = original;
        }

        @Override
        public void setAttribute(String key, String value) {
            this.attributes.put(key, value);
            this.dirty = true;
        }

        @Override
        public IDebuggerSettings getOriginal() {
            return this.original;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }
    }
}

