/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Enumeration;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentRegionEnumeration;

public class CoreNodeList
implements IStructuredDocumentRegionList {
    int countedLength;
    int currentIndex = -1;
    IStructuredDocumentRegion[] flatNodes;
    IStructuredDocumentRegion head;

    public CoreNodeList() {
        this.flatNodes = new IStructuredDocumentRegion[0];
    }

    public CoreNodeList(IStructuredDocumentRegion newHead) {
        this.head = newHead;
        int count = 0;
        IStructuredDocumentRegion countNode = newHead;
        while (countNode != null) {
            ++count;
            countNode = countNode.getNext();
        }
        this.flatNodes = new IStructuredDocumentRegion[count];
        countNode = newHead;
        count = 0;
        while (countNode != null) {
            this.flatNodes[count++] = countNode;
            countNode = countNode.getNext();
        }
        if (count > 0) {
            this.currentIndex = 0;
            this.countedLength = count;
        }
    }

    public CoreNodeList(IStructuredDocumentRegion start, IStructuredDocumentRegion end) {
        this.head = start;
        int count = 0;
        IStructuredDocumentRegion countNode = start;
        if (start != null && end != null) {
            count = 1;
            while (countNode != null && countNode != end) {
                ++count;
                countNode = countNode.getNext();
            }
        }
        if (countNode == null) {
            --count;
        }
        if (count < 0) {
            count = 0;
        }
        this.flatNodes = new IStructuredDocumentRegion[count];
        if (count > 0) {
            this.flatNodes[0] = countNode = start;
            int i = 1;
            while (i < count) {
                this.flatNodes[i] = this.flatNodes[i - 1].getNext();
                ++i;
            }
        }
        this.currentIndex = 0;
        this.countedLength = count;
    }

    @Override
    public Enumeration elements() {
        StructuredDocumentRegionEnumeration result = null;
        result = this.flatNodes != null && this.flatNodes.length > 0 ? new StructuredDocumentRegionEnumeration(this.flatNodes[0], this.flatNodes[this.flatNodes.length - 1]) : new StructuredDocumentRegionEnumeration(null);
        return result;
    }

    @Override
    public int getLength() {
        return this.flatNodes.length;
    }

    public boolean includes(Object o) {
        if (this.flatNodes == null) {
            return false;
        }
        int i = 0;
        while (i < this.flatNodes.length) {
            if (this.flatNodes[i] == o) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IStructuredDocumentRegion item(int i) {
        return this.flatNodes[i];
    }
}

