/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task.adapter;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

final class ProjectTaskNodeAdapter
implements IPropertySource {
    private static final String PROPERTY_NAME = "task.name";
    private static final String PROPERTY_DESCRIPTION = "task.description";
    private static final String PROPERTY_PATH = "task.path";
    private static final String PROPERTY_PUBLIC = "task.public";
    private static final String PROPERTY_TYPE = "task.type";
    private final ProjectTaskNode projectTask;

    ProjectTaskNodeAdapter(ProjectTaskNode taskNode) {
        this.projectTask = (ProjectTaskNode)Preconditions.checkNotNull((Object)taskNode);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROPERTY_NAME, "Name"), new PropertyDescriptor((Object)PROPERTY_DESCRIPTION, "Description"), new PropertyDescriptor((Object)PROPERTY_PATH, "Path"), new PropertyDescriptor((Object)PROPERTY_PUBLIC, "Public"), new PropertyDescriptor((Object)PROPERTY_TYPE, "Type")};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_NAME)) {
            return this.projectTask.getName();
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return this.projectTask.getDescription();
        }
        if (id.equals(PROPERTY_PATH)) {
            return this.projectTask.getPath();
        }
        if (id.equals(PROPERTY_PUBLIC)) {
            return this.projectTask.isPublic();
        }
        if (id.equals(PROPERTY_TYPE)) {
            return "Gradle Project Task";
        }
        throw new IllegalStateException("Unsupported project task property: " + id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

