/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.view;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class Viewer {
    private IConfigurationElement element;
    protected String[] encodings = null;

    public Viewer(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getLabel() {
        String label = this.element.getAttribute("label");
        if (label == null) {
            return "n/a";
        }
        return label;
    }

    public String[] getEncodings() {
        if (this.encodings == null) {
            String encodingString = this.element.getAttribute("encodings");
            if (Trace.FINEST) {
                Trace.trace("/finest", "encodingString from extension point : " + encodingString);
            }
            if (encodingString != null) {
                this.encodings = encodingString.split(",");
                int size = this.encodings.length;
                int i = 0;
                while (i < size) {
                    this.encodings[i] = this.encodings[i].trim();
                    ++i;
                }
            }
        }
        if (Trace.FINEST) {
            Trace.trace("/finest", "Get encodings : " + this.encodings);
        }
        return this.encodings;
    }

    public ContentViewer createViewer() {
        try {
            return (ContentViewer)this.element.createExecutableExtension("class");
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Could not create viewer" + this.toString(), e);
            }
            return null;
        }
    }

    public boolean isRequestViewer() {
        return this.element.getAttribute("type").toLowerCase().indexOf("request") >= 0;
    }

    public boolean isResponseViewer() {
        return this.element.getAttribute("type").toLowerCase().indexOf("response") >= 0;
    }

    public String toString() {
        return "ContentViewer[" + this.getId() + "]";
    }
}

