/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class NameSuggestVisitor
extends AbstractVisitor {
    private LinkedList<String> suggestions = new LinkedList();

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(LinkedList<String> suggestions) {
        this.suggestions = suggestions;
    }

    public boolean visit(Identifier identifier) {
        if (!this.suggestions.contains(identifier.getName())) {
            this.suggestions.addFirst(identifier.getName());
        }
        return false;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        functionInvocation.getFunctionName().accept((Visitor)this);
        return false;
    }

    public boolean visit(Scalar scalar) {
        String value = "";
        switch (scalar.getScalarType()) {
            case 0: {
                value = "i";
                break;
            }
            case 1: {
                value = "d";
                break;
            }
            case 2: {
                if (scalar.getStringValue().equalsIgnoreCase("true") || scalar.getStringValue().equalsIgnoreCase("false")) {
                    value = "bool";
                    break;
                }
                value = "str";
                break;
            }
            case 4: {
                value = scalar.getStringValue().toLowerCase().replaceAll("_", "");
                break;
            }
        }
        this.suggestions.add(value);
        return false;
    }
}

