/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;

class ADTContentOutlineRefreshJob
extends Job {
    private static final long UPDATE_DELAY = 300L;
    private final List nodesToRefresh = new ArrayList(5);
    private final TreeViewer viewer;

    public ADTContentOutlineRefreshJob(Viewer viewer) {
        super("Refreshing XSD outline");
        this.setPriority(30);
        this.setSystem(true);
        this.viewer = (TreeViewer)viewer;
    }

    private synchronized void addRefreshRequest(IADTObject adtObject) {
        if (this.nodesToRefresh.contains(adtObject)) {
            return;
        }
        this.nodesToRefresh.add(adtObject);
    }

    protected void canceling() {
        this.nodesToRefresh.clear();
        super.canceling();
    }

    private void doRefresh(final IADTObject adtObject) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                boolean isValidViewer;
                boolean bl = isValidViewer = ADTContentOutlineRefreshJob.this.viewer != null && !ADTContentOutlineRefreshJob.this.viewer.getControl().isDisposed();
                if (isValidViewer) {
                    ADTContentOutlineRefreshJob.this.viewer.refresh((Object)adtObject);
                    if (!(adtObject instanceof CategoryAdapter)) {
                        ADTContentOutlineRefreshJob.this.viewer.reveal((Object)adtObject);
                    }
                }
            }
        });
    }

    private synchronized IADTObject[] getNodesToRefresh() {
        IADTObject[] toRefresh = new IADTObject[this.nodesToRefresh.size()];
        this.nodesToRefresh.toArray(toRefresh);
        this.nodesToRefresh.clear();
        return toRefresh;
    }

    public void refresh(IADTObject adtObject) {
        if (adtObject == null) {
            return;
        }
        this.addRefreshRequest(adtObject);
        this.schedule(300L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            this.performRefreshes(monitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return status;
    }

    private void performRefreshes(IProgressMonitor monitor) {
        IADTObject[] nodes = this.getNodesToRefresh();
        int index = 0;
        while (index < nodes.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IADTObject node = nodes[index];
            this.doRefresh(node);
            ++index;
        }
    }
}

