/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.extractor;

import java.io.Serializable;
import java.util.Objects;

public class EmbeddedDocumentBytesConfig
implements Serializable {
    private static final long serialVersionUID = -3861669115439125268L;
    public static EmbeddedDocumentBytesConfig SKIP = new EmbeddedDocumentBytesConfig(false);
    private boolean extractEmbeddedDocumentBytes;
    private int zeroPadName = 0;
    private SUFFIX_STRATEGY suffixStrategy = SUFFIX_STRATEGY.NONE;
    private String embeddedIdPrefix = "-";
    private String emitter;
    private boolean includeOriginal = false;
    private String emitKeyBase = "";

    public EmbeddedDocumentBytesConfig() {
        this.extractEmbeddedDocumentBytes = true;
    }

    public EmbeddedDocumentBytesConfig(boolean extractEmbeddedDocumentBytes) {
        this.extractEmbeddedDocumentBytes = extractEmbeddedDocumentBytes;
    }

    public static EmbeddedDocumentBytesConfig getSKIP() {
        return SKIP;
    }

    public boolean isExtractEmbeddedDocumentBytes() {
        return this.extractEmbeddedDocumentBytes;
    }

    public void setExtractEmbeddedDocumentBytes(boolean extractEmbeddedDocumentBytes) {
        this.extractEmbeddedDocumentBytes = extractEmbeddedDocumentBytes;
    }

    public int getZeroPadName() {
        return this.zeroPadName;
    }

    public SUFFIX_STRATEGY getSuffixStrategy() {
        return this.suffixStrategy;
    }

    public String getEmbeddedIdPrefix() {
        return this.embeddedIdPrefix;
    }

    public String getEmitter() {
        return this.emitter;
    }

    public boolean isIncludeOriginal() {
        return this.includeOriginal;
    }

    public void setZeroPadName(int zeroPadName) {
        this.zeroPadName = zeroPadName;
    }

    public void setSuffixStrategy(SUFFIX_STRATEGY suffixStrategy) {
        this.suffixStrategy = suffixStrategy;
    }

    public void setSuffixStrategy(String suffixStrategy) {
        this.setSuffixStrategy(SUFFIX_STRATEGY.valueOf(suffixStrategy));
    }

    public void setEmbeddedIdPrefix(String embeddedIdPrefix) {
        this.embeddedIdPrefix = embeddedIdPrefix;
    }

    public void setEmitter(String emitter) {
        this.emitter = emitter;
    }

    public void setIncludeOriginal(boolean includeOriginal) {
        this.includeOriginal = includeOriginal;
    }

    public void setEmitKeyBase(String emitKeyBase) {
        this.emitKeyBase = emitKeyBase;
    }

    public String getEmitKeyBase() {
        return this.emitKeyBase;
    }

    public String toString() {
        return "EmbeddedDocumentBytesConfig{extractEmbeddedDocumentBytes=" + this.extractEmbeddedDocumentBytes + ", zeroPadName=" + this.zeroPadName + ", suffixStrategy=" + String.valueOf((Object)this.suffixStrategy) + ", embeddedIdPrefix='" + this.embeddedIdPrefix + "', emitter='" + this.emitter + "', includeOriginal=" + this.includeOriginal + ", emitKeyBase='" + this.emitKeyBase + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedDocumentBytesConfig that = (EmbeddedDocumentBytesConfig)o;
        return this.extractEmbeddedDocumentBytes == that.extractEmbeddedDocumentBytes && this.zeroPadName == that.zeroPadName && this.includeOriginal == that.includeOriginal && this.suffixStrategy == that.suffixStrategy && Objects.equals(this.embeddedIdPrefix, that.embeddedIdPrefix) && Objects.equals(this.emitter, that.emitter) && Objects.equals(this.emitKeyBase, that.emitKeyBase);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.extractEmbeddedDocumentBytes);
        result = 31 * result + this.zeroPadName;
        result = 31 * result + Objects.hashCode((Object)this.suffixStrategy);
        result = 31 * result + Objects.hashCode(this.embeddedIdPrefix);
        result = 31 * result + Objects.hashCode(this.emitter);
        result = 31 * result + Boolean.hashCode(this.includeOriginal);
        result = 31 * result + Objects.hashCode(this.emitKeyBase);
        return result;
    }

    public static enum SUFFIX_STRATEGY {
        NONE,
        EXISTING,
        DETECTED;


        public static SUFFIX_STRATEGY parse(String s) {
            if (s.equalsIgnoreCase("none")) {
                return NONE;
            }
            if (s.equalsIgnoreCase("existing")) {
                return EXISTING;
            }
            if (s.equalsIgnoreCase("detected")) {
                return DETECTED;
            }
            throw new IllegalArgumentException("can't parse " + s);
        }
    }
}

