/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.dltk.dbgp.IDbgpRawPacket;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.Messages;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;

public class DbgpRawPacket
implements IDbgpRawPacket {
    private final int size;
    private final byte[] xml;

    protected static int readPacketSize(InputStream input) throws IOException {
        int size;
        block3: {
            int b;
            size = 0;
            while (true) {
                if ((b = input.read()) == -1) {
                    throw new IOException();
                }
                if (b == 0) break block3;
                if (b < 48 || b > 57) break;
                size = size * 10 + (b - 48);
            }
            String msg = NLS.bind((String)Messages.DbgpRawPacket_invalidCharInPacketSize, (Object)Integer.toString(b));
            DLTKDebugPlugin.logWarning(msg);
            throw new IOException(msg);
        }
        if (size == 0) {
            throw new IOException(Messages.DbgpRawPacket_zeroPacketSize);
        }
        return size;
    }

    protected static byte[] readPacketXml(InputStream input, int size) throws IOException {
        int n;
        byte[] bytes = new byte[size];
        int offset = 0;
        while (offset < size && (n = input.read(bytes, offset, size - offset)) != -1) {
            offset += n;
        }
        if (offset != size) {
            throw new IOException(Messages.DbgpRawPacket_cantReadPacketBody);
        }
        if (input.read() != 0) {
            throw new IOException(Messages.DbgpRawPacket_noTerminationByte);
        }
        return bytes;
    }

    public static DbgpRawPacket readPacket(InputStream input) throws IOException {
        int size = DbgpRawPacket.readPacketSize(input);
        byte[] xml = DbgpRawPacket.readPacketXml(input, size);
        return new DbgpRawPacket(size, xml);
    }

    public DbgpRawPacket(int size, byte[] xml) {
        this.size = size;
        this.xml = xml;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getXml() {
        return this.xml;
    }

    public Document getParsedXml() throws DbgpException {
        return DbgpXmlParser.parseXml(this.xml);
    }

    public String toString() {
        return "DbgpPacket (" + this.size + " bytes) " + String.valueOf(this.xml);
    }

    @Override
    public String getPacketAsString() {
        return new String(this.xml, StandardCharsets.US_ASCII);
    }
}

