/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.model;

import org.eclipse.birt.chart.internal.model.ContinuedFraction;
import org.eclipse.birt.chart.internal.model.Fraction;

public class FractionApproximator {
    public static Fraction getExactFraction(double decimal) {
        ContinuedFraction cf = new ContinuedFraction(decimal);
        return cf.getExactFraction();
    }

    public static Fraction getFractionWithMaxDigits(double decimal, int maxDigitsForDenominator) {
        ContinuedFraction cf = new ContinuedFraction(decimal);
        return cf.getFractionWithMaxDigits(maxDigitsForDenominator);
    }

    public static Fraction getFractionWithNumerator(double decimal, long numerator) {
        if (decimal == 0.0) {
            return new Fraction(0L, 1L);
        }
        if (Math.abs(Math.round(decimal)) + 1L > Math.abs(numerator)) {
            return FractionApproximator.getExactFraction(decimal);
        }
        return new Fraction(numerator, Math.round((double)numerator / decimal));
    }
}

