/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public class MidxPackFilter {
    private static Comparator<DfsPackDescription> midxComparator = Comparator.comparingLong(DfsPackDescription::getLastModified).thenComparingLong(MidxPackFilter::getTotalCoveredObjects).reversed();

    private MidxPackFilter() {
    }

    private static long getTotalCoveredObjects(DfsPackDescription desc) {
        long objCount = 0L;
        DfsPackDescription current = desc;
        while (current != null) {
            objCount += current.getObjectCount();
            current = current.getMultiPackIndexBase();
        }
        return objCount;
    }

    public static List<DfsPackDescription> skipMidxs(List<DfsPackDescription> packs) {
        return packs.stream().filter(desc -> !desc.hasFileExt(PackExt.MULTI_PACK_INDEX)).collect(Collectors.toList());
    }

    public static List<DfsPackDescription> useMidx(List<DfsPackDescription> packs) {
        List<DfsPackDescription> midxs = packs.stream().filter(desc -> desc.hasFileExt(PackExt.MULTI_PACK_INDEX)).sorted(midxComparator).toList();
        if (midxs.isEmpty()) {
            return packs;
        }
        HashSet<DfsPackDescription> packsSet = new HashSet<DfsPackDescription>(packs);
        Optional<DfsPackDescription> bestMidx = midxs.stream().filter(midx -> MidxPackFilter.isValid(midx, packsSet)).findFirst();
        if (bestMidx.isEmpty()) {
            return MidxPackFilter.skipMidxs(packs);
        }
        Set<DfsPackDescription> coveredPacksAndMidxs = MidxPackFilter.getAllCoveredPacks(bestMidx.get());
        return packs.stream().filter(p -> !coveredPacksAndMidxs.contains(p)).filter(p -> !p.hasFileExt(PackExt.MULTI_PACK_INDEX) || p.equals(bestMidx.get())).collect(Collectors.toCollection(ArrayList::new));
    }

    private static boolean isValid(DfsPackDescription midx, Set<DfsPackDescription> packs) {
        DfsPackDescription tip = midx;
        while (tip != null) {
            if (!packs.containsAll(tip.getCoveredPacks())) {
                return false;
            }
            tip = tip.getMultiPackIndexBase();
        }
        return true;
    }

    private static Set<DfsPackDescription> getAllCoveredPacks(DfsPackDescription midx) {
        HashSet<DfsPackDescription> covered = new HashSet<DfsPackDescription>();
        DfsPackDescription current = midx;
        while (current != null) {
            DfsPackDescription base;
            if (!current.getCoveredPacks().isEmpty()) {
                covered.addAll(current.getCoveredPacks());
            }
            if ((base = current.getMultiPackIndexBase()) != null) {
                covered.add(base);
            }
            current = base;
        }
        return covered;
    }
}

