/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.IdentifierUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameRefactoringWizard;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class LSPInlineRenameLinkedMode {
    private static final String INLINE_RENAME_PREFERENCE = "org.eclipse.lsp4e.inlineRename";
    private final IDocument document;
    private final ITextViewer viewer;
    private final int offset;
    private final IRegion renameRegion;
    private final String originalName;
    private final List<IRegion> occurrences;
    private final @Nullable LanguageServerWrapper refactoringServer;
    private @Nullable LinkedPosition linkedPosition;
    private final List<LinkedPosition> linkedPositions = new ArrayList<LinkedPosition>();
    private final List<String> originalContents = new ArrayList<String>();
    private volatile boolean cancelled = false;

    static boolean start(final IDocument document, final ITextViewer viewer, final int offset, final Shell shell) {
        if (!LSPInlineRenameLinkedMode.isInlineRenameEnabled()) {
            return false;
        }
        Job job = new Job(Messages.rename_title){

            protected IStatus run(IProgressMonitor monitor) {
                List<IRegion> occurrences;
                String originalName;
                Object renameRegion;
                LSPRenameProcessor processor = new LSPRenameProcessor(document, offset);
                RefactoringStatus status = LSPInlineRenameLinkedMode.runPrepareRename(processor);
                if (status == null || status.hasFatalError()) {
                    LanguageServerPlugin.logWarning("Inline rename: prepareRename returned fatal status or null, falling back to dialog");
                    LSPInlineRenameLinkedMode.scheduleDialogFallback(document, offset, shell);
                    return Status.OK_STATUS;
                }
                Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> prepareResult = processor.getPrepareRenameResult();
                try {
                    renameRegion = prepareResult != null ? LSPInlineRenameLinkedMode.toRegion(document, offset, prepareResult) : IdentifierUtil.computeIdentifierRegion(document, offset);
                    originalName = document.get(renameRegion.getOffset(), renameRegion.getLength());
                    occurrences = LSPInlineRenameLinkedMode.collectSameFileOccurrences(document, offset, (IRegion)renameRegion);
                }
                catch (BadLocationException ex) {
                    LanguageServerPlugin.logError(ex);
                    LSPInlineRenameLinkedMode.scheduleDialogFallback(document, offset, shell);
                    return Status.OK_STATUS;
                }
                LSPInlineRenameLinkedMode mode = new LSPInlineRenameLinkedMode(document, viewer, offset, (IRegion)renameRegion, originalName, occurrences, processor.getRefactoringServer());
                mode.start();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return true;
    }

    private static boolean isInlineRenameEnabled() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        return prefs.getBoolean(INLINE_RENAME_PREFERENCE, true);
    }

    private static @Nullable RefactoringStatus runPrepareRename(LSPRenameProcessor processor) {
        try {
            return processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static void scheduleDialogFallback(IDocument document, int offset, Shell shell) {
        if (shell.isDisposed()) {
            return;
        }
        shell.getDisplay().asyncExec(() -> {
            if (shell.isDisposed()) {
                return;
            }
            LSPRenameProcessor processor = new LSPRenameProcessor(document, offset);
            ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            LSPRenameRefactoringWizard wizard = new LSPRenameRefactoringWizard((Refactoring)refactoring);
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                operation.run(shell, Messages.rename_title);
            }
            catch (InterruptedException ex) {
                LanguageServerPlugin.logError(ex);
                Thread.currentThread().interrupt();
            }
        });
    }

    private static IRegion toRegion(IDocument document, int offset, Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> prepare) throws BadLocationException {
        Range range = prepare.isFirst() ? (Range)prepare.getFirst() : (prepare.isSecond() ? NullSafetyHelper.castNonNull((PrepareRenameResult)prepare.getSecond()).getRange() : IdentifierUtil.computeIdentifierRange(document, offset));
        int startOffset = LSPEclipseUtils.toOffset(range.getStart(), document);
        int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), document);
        return new Region(startOffset, endOffset - startOffset);
    }

    private static List<IRegion> collectSameFileOccurrences(IDocument document, int offset, IRegion primaryRegion) {
        ArrayList<IRegion> regions = new ArrayList<IRegion>();
        regions.add(primaryRegion);
        try {
            TextDocumentIdentifier textDocument = NullSafetyHelper.castNonNull(LSPEclipseUtils.toTextDocumentIdentifier(document));
            DocumentHighlightParams highlightParams = new DocumentHighlightParams(textDocument, LSPEclipseUtils.toPosition(offset, document));
            List highlightLists = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentHighlightProvider)).collectAll((w, ls) -> ls.getTextDocumentService().documentHighlight(highlightParams)).get(1L, TimeUnit.SECONDS);
            for (List highlights : highlightLists) {
                if (highlights == null) continue;
                highlights.stream().filter(Objects::nonNull).forEach(highlight -> {
                    try {
                        int start = LSPEclipseUtils.toOffset(highlight.getRange().getStart(), document);
                        int end = LSPEclipseUtils.toOffset(highlight.getRange().getEnd(), document);
                        Region region = new Region(start, end - start);
                        if (regions.stream().noneMatch(r -> r.getOffset() == region.getOffset() && r.getLength() == region.getLength())) {
                            regions.add((IRegion)region);
                        }
                    }
                    catch (BadLocationException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                });
            }
        }
        catch (RuntimeException | ExecutionException | TimeoutException | BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
        catch (InterruptedException ex) {
            LanguageServerPlugin.logError(ex);
            Thread.currentThread().interrupt();
        }
        return regions;
    }

    private LSPInlineRenameLinkedMode(IDocument document, ITextViewer viewer, int offset, IRegion renameRegion, String originalName, List<IRegion> occurrences, @Nullable LanguageServerWrapper refactoringServer) {
        this.document = document;
        this.viewer = viewer;
        this.offset = offset;
        this.renameRegion = renameRegion;
        this.originalName = originalName;
        this.occurrences = occurrences;
        this.refactoringServer = refactoringServer;
        for (IRegion region : occurrences) {
            try {
                this.originalContents.add(document.get(region.getOffset(), region.getLength()));
            }
            catch (BadLocationException e) {
                this.originalContents.add(originalName);
                LanguageServerPlugin.logError(e);
            }
        }
    }

    private boolean doRename(String newName) {
        WorkspaceEdit edit;
        block4: {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            params.setTextDocument(NullSafetyHelper.castNonNull(LSPEclipseUtils.toTextDocumentIdentifier(this.document)));
            params.setNewName(newName);
            LanguageServerWrapper server = this.refactoringServer;
            edit = server != null ? (WorkspaceEdit)server.execute(ls -> ls.getTextDocumentService().rename(params)).get(1L, TimeUnit.SECONDS) : (WorkspaceEdit)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withCapability(ServerCapabilities::getRenameProvider)).computeFirst(ls -> ls.getTextDocumentService().rename(params)).get(1L, TimeUnit.SECONDS).orElse(null);
            if (edit != null) break block4;
            return false;
        }
        try {
            LSPEclipseUtils.applyWorkspaceEdit(edit, Messages.rename_title);
            return true;
        }
        catch (RuntimeException | ExecutionException | TimeoutException | BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
        catch (InterruptedException ex) {
            LanguageServerPlugin.logError(ex);
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable LinkedModeUI.ExitFlags exitPolicy(@Nullable LinkedModeModel environment, VerifyEvent event, int offset, int length) {
        if (event.character == '\u001b') {
            this.cancelled = true;
            return new LinkedModeUI.ExitFlags(1, false);
        }
        if (event.character == '\r' || event.character == '\n') {
            this.cancelled = false;
            return new LinkedModeUI.ExitFlags(1, false);
        }
        return null;
    }

    private void installLinkedMode() {
        try {
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            LinkedPosition primary = null;
            for (IRegion region : this.occurrences) {
                LinkedPosition position = new LinkedPosition(this.document, region.getOffset(), region.getLength());
                this.linkedPositions.add(position);
                group.addPosition(position);
                if (primary != null && (region.getOffset() != this.renameRegion.getOffset() || region.getLength() != this.renameRegion.getLength())) continue;
                primary = position;
            }
            this.linkedPosition = primary;
            model.addGroup(group);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    if (LSPInlineRenameLinkedMode.this.cancelled) {
                        UI.runOnUIThread(() -> {
                            StyledText widget = LSPInlineRenameLinkedMode.this.viewer.getTextWidget();
                            if (widget != null && !widget.isDisposed()) {
                                widget.setRedraw(false);
                            }
                            try {
                                try {
                                    int i = LSPInlineRenameLinkedMode.this.linkedPositions.size() - 1;
                                    while (i >= 0) {
                                        LinkedPosition pos = LSPInlineRenameLinkedMode.this.linkedPositions.get(i);
                                        String original = i < LSPInlineRenameLinkedMode.this.originalContents.size() ? LSPInlineRenameLinkedMode.this.originalContents.get(i) : LSPInlineRenameLinkedMode.this.originalName;
                                        LSPInlineRenameLinkedMode.this.document.replace(pos.getOffset(), pos.getLength(), original);
                                        --i;
                                    }
                                }
                                catch (BadLocationException ex) {
                                    LanguageServerPlugin.logError(ex);
                                    if (widget != null && !widget.isDisposed()) {
                                        widget.setRedraw(true);
                                    }
                                }
                            }
                            finally {
                                if (widget != null && !widget.isDisposed()) {
                                    widget.setRedraw(true);
                                }
                            }
                        });
                    } else {
                        LSPInlineRenameLinkedMode.this.scheduleRenameJob();
                    }
                }

                public void resume(LinkedModeModel environment, int flags) {
                }

                public void suspend(LinkedModeModel environment) {
                }
            });
            model.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.viewer);
            ui.setExitPolicy(this::exitPolicy);
            ui.enter();
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private void scheduleRenameJob() {
        Job job = new Job(Messages.rename_title){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LinkedPosition position = LSPInlineRenameLinkedMode.this.linkedPosition;
                    if (position == null) {
                        LanguageServerPlugin.logWarning("Inline rename: linkedPosition is null, skipping");
                        return Status.OK_STATUS;
                    }
                    String newName = LSPInlineRenameLinkedMode.this.document.get(position.getOffset(), position.getLength());
                    if (newName.equals(LSPInlineRenameLinkedMode.this.originalName)) {
                        return Status.OK_STATUS;
                    }
                    UI.runOnUIThread(() -> {
                        block13: {
                            StyledText widget = LSPInlineRenameLinkedMode.this.viewer.getTextWidget();
                            int offset = position.getOffset();
                            int length = position.getLength();
                            if (widget == null || widget.isDisposed()) {
                                try {
                                    LSPInlineRenameLinkedMode.this.document.replace(offset, length, LSPInlineRenameLinkedMode.this.originalName);
                                }
                                catch (BadLocationException e) {
                                    LanguageServerPlugin.logError(e);
                                    return;
                                }
                                boolean success = LSPInlineRenameLinkedMode.this.doRename(newName);
                                if (!success) {
                                    try {
                                        LSPInlineRenameLinkedMode.this.document.replace(offset, length, newName);
                                    }
                                    catch (BadLocationException e) {
                                        LanguageServerPlugin.logError(e);
                                    }
                                }
                                return;
                            }
                            widget.setRedraw(false);
                            try {
                                try {
                                    LSPInlineRenameLinkedMode.this.document.replace(offset, length, LSPInlineRenameLinkedMode.this.originalName);
                                    boolean success = LSPInlineRenameLinkedMode.this.doRename(newName);
                                    if (success) break block13;
                                    try {
                                        LSPInlineRenameLinkedMode.this.document.replace(offset, length, newName);
                                    }
                                    catch (BadLocationException e) {
                                        LanguageServerPlugin.logError(e);
                                    }
                                }
                                catch (BadLocationException e) {
                                    LanguageServerPlugin.logError(e);
                                    widget.setRedraw(true);
                                }
                            }
                            finally {
                                widget.setRedraw(true);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (BadLocationException ex) {
                    return new Status(4, "org.eclipse.lsp4e", ex.getMessage(), (Throwable)ex);
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private boolean start() {
        StyledText styledText = this.viewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return false;
        }
        styledText.getDisplay().asyncExec(() -> {
            if (!styledText.isDisposed()) {
                this.installLinkedMode();
            }
        });
        return true;
    }
}

