/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.util.List;
import java.util.Map;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.midx.MidxIterators;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.lib.MutableObjectId;

class PackIndexMerger {
    private static final int LIMIT_31_BITS = Integer.MAX_VALUE;
    private static final long LIMIT_32_BITS = 0xFFFFFFFFL;
    private final Map<String, PackIndex> packs;
    private final boolean needsLargeOffsetsChunk;
    private final int offsetsOver31BitsCount;
    private final int uniqueObjectCount;
    private final int[] objectsPerPack;

    PackIndexMerger(Map<String, PackIndex> packs) {
        this.packs = packs;
        this.objectsPerPack = new int[packs.size()];
        int objectCount = 0;
        boolean hasLargeOffsets = false;
        int over31bits = 0;
        MutableObjectId lastSeen = new MutableObjectId();
        MultiPackIndex.MidxIterator it = this.bySha1Iterator();
        while (it.hasNext()) {
            MultiPackIndex.MutableEntry entry = (MultiPackIndex.MutableEntry)it.next();
            if (entry.getOffset() > 0xFFFFFFFFL) {
                hasLargeOffsets = true;
            }
            if (entry.getOffset() > Integer.MAX_VALUE) {
                ++over31bits;
            }
            lastSeen.fromObjectId(entry.oid);
            ++objectCount;
            int n = entry.getPackId();
            this.objectsPerPack[n] = this.objectsPerPack[n] + 1;
        }
        this.uniqueObjectCount = objectCount;
        this.offsetsOver31BitsCount = over31bits;
        this.needsLargeOffsetsChunk = hasLargeOffsets;
    }

    int getUniqueObjectCount() {
        return this.uniqueObjectCount;
    }

    boolean needsLargeOffsetsChunk() {
        return this.needsLargeOffsetsChunk;
    }

    int getOffsetsOver31BitsCount() {
        return this.offsetsOver31BitsCount;
    }

    int[] getObjectsPerPack() {
        return this.objectsPerPack;
    }

    List<String> getPackNames() {
        return this.packs.keySet().stream().toList();
    }

    int getPackCount() {
        return this.packs.size();
    }

    MultiPackIndex.MidxIterator bySha1Iterator() {
        List<MultiPackIndex.MidxIterator> list = this.packs.entrySet().stream().map(e -> MidxIterators.fromPackIndexIterator((String)e.getKey(), (PackIndex)e.getValue())).toList();
        return MidxIterators.dedup(MidxIterators.join(list));
    }
}

