/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.externaltool;

import java.util.ArrayList;

public class ArgsSeparator {
    private static final char BACKSLASH = '\\';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char SPACE = ' ';
    private static final String[] NO_ARGS = new String[0];

    public String[] splitArguments(String s) {
        if (s == null || s.isEmpty()) {
            return NO_ARGS;
        }
        ParserState state = ParserState.NORMAL;
        StringBuilder current = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean lastTokenInQuotes = false;
        char previous = '\u0000';
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (state) {
                case IN_SINGLE_QUOTE: {
                    if (previous != '\\' && c == '\'') {
                        lastTokenInQuotes = true;
                        state = ParserState.NORMAL;
                        break;
                    }
                    previous = c;
                    current.append(c);
                    break;
                }
                case IN_DOUBLE_QUOTE: {
                    if (previous != '\\' && c == '\"') {
                        lastTokenInQuotes = true;
                        state = ParserState.NORMAL;
                        break;
                    }
                    previous = c;
                    current.append(c);
                    break;
                }
                default: {
                    switch (c) {
                        case '\'': {
                            if (previous == 92) break;
                            state = ParserState.IN_SINGLE_QUOTE;
                            break;
                        }
                        case '\"': {
                            if (previous == 92) break;
                            state = ParserState.IN_DOUBLE_QUOTE;
                            break;
                        }
                        case ' ': {
                            if (!lastTokenInQuotes && current.length() == 0) break;
                            args.add(current.toString());
                            current.setLength(0);
                            break;
                        }
                        default: {
                            previous = c;
                            current.append(c);
                        }
                    }
                    lastTokenInQuotes = false;
                }
            }
            ++n2;
        }
        if (lastTokenInQuotes || current.length() != 0) {
            args.add(current.toString());
        }
        if (state != ParserState.NORMAL) {
            throw new IllegalArgumentException("Unbalanced quotes in " + s);
        }
        return args.toArray(new String[args.size()]);
    }

    private static enum ParserState {
        NORMAL,
        IN_SINGLE_QUOTE,
        IN_DOUBLE_QUOTE;

    }
}

