/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;

public abstract class MethodNameMatch {
    public String getFullyQualifiedName() {
        return this.getMethod().getFullyQualifiedName();
    }

    public abstract int getModifiers();

    public IProjectFragment getProjectFragment() {
        return (IProjectFragment)this.getMethod().getAncestor(3);
    }

    public String getPackageName() {
        IModelElement parent = this.getMethod().getParent();
        if (parent.getElementType() == 5) {
            ISourceModule source = (ISourceModule)parent;
            return source.getElementName();
        }
        return null;
    }

    public String getSimpleMethodName() {
        return this.getMethod().getElementName();
    }

    public abstract IMethod getMethod();

    public String getMethodContainerName() {
        IType outerType = this.getMethod().getDeclaringType();
        if (outerType != null) {
            return outerType.getTypeQualifiedName();
        }
        return this.getMethod().getSourceModule().getParent().getElementName();
    }

    public String getTypeQualifiedName() {
        return this.getMethod().getFullyQualifiedName();
    }
}

