/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PlanningPart;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorPlanningPart
extends AbstractTaskEditorPart {
    private final PlanningPart part = new PlanningPart(2){

        @Override
        protected void fillToolBar(ToolBarManager toolBarManager) {
            NotesAction notesAction = new NotesAction();
            notesAction.setEnabled(this.needsNotes());
            toolBarManager.add((IAction)notesAction);
            toolBarManager.add((IAction)TaskEditorPlanningPart.this.getMaximizePartAction());
        }
    };

    @Override
    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        super.initialize(taskEditorPage);
        boolean needsDueDate = !taskEditorPage.getConnector().hasRepositoryDueDate(taskEditorPage.getTaskRepository(), taskEditorPage.getTask(), this.getTaskData());
        CommonTextSupport textSupport = (CommonTextSupport)this.getTaskEditorPage().getAdapter(CommonTextSupport.class);
        this.part.initialize(taskEditorPage.getManagedForm(), taskEditorPage.getTaskRepository(), (AbstractTask)taskEditorPage.getTask(), needsDueDate, taskEditorPage, textSupport);
        this.part.setNeedsNotes(!this.getModel().getTaskData().isNew());
        this.part.setAlwaysExpand(this.getModel().getTaskData().isNew());
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        this.part.createControl(parent, toolkit);
        this.part.getSection().setToolTipText(Messages.TaskEditorPlanningPart_TaskEditorPlanningPart_tooltip);
        this.setSection(toolkit, this.part.getSection());
    }

    @Override
    protected Control getLayoutControl() {
        return this.part.getLayoutControl();
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.part.commit(onSave);
    }

    public boolean isDirty() {
        return super.isDirty() || this.part.isDirty();
    }

    public void dispose() {
        this.part.dispose();
    }

    public PlanningPart getPlanningPart() {
        return this.part;
    }

    private class NotesAction
    extends Action {
        public NotesAction() {
            this.setImageDescriptor(CommonImages.NOTES_SMALL);
            this.setToolTipText(Messages.TaskEditorPlanningPart_Add_Private_Notes_Tooltip);
        }

        public void run() {
            CommonFormUtil.setExpanded((ExpandableComposite)TaskEditorPlanningPart.this.part.getSection(), (boolean)true);
            if (TaskEditorPlanningPart.this.part.getNoteEditor() != null && TaskEditorPlanningPart.this.part.getNoteEditor().getControl() != null) {
                TaskEditorPlanningPart.this.part.getNoteEditor().getControl().setFocus();
            } else {
                TaskEditorPlanningPart.this.part.getControl().setFocus();
            }
        }
    }
}

