/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.csv.ClassRowWriter;

class CSVPackageHandler
implements IReportVisitor {
    private final ClassRowWriter writer;
    private final String groupName;
    private final String packageName;

    public CSVPackageHandler(ClassRowWriter writer, String groupName, String packageName) {
        this.writer = writer;
        this.groupName = groupName;
        this.packageName = packageName;
    }

    public IReportVisitor visitChild(ICoverageNode node) throws IOException {
        ICoverageNode.ElementType type = node.getElementType();
        switch (type) {
            case CLASS: {
                IClassCoverage classNode = (IClassCoverage)node;
                this.writer.writeRow(this.groupName, this.packageName, classNode);
                return IReportVisitor.NOP;
            }
            case SOURCEFILE: {
                return IReportVisitor.NOP;
            }
        }
        throw new AssertionError((Object)String.format("Unexpected child node %s.", new Object[]{type}));
    }

    public void visitEnd(ISourceFileLocator sourceFileLocator) {
    }
}

