/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.ReportOutputFolder;
import org.jacoco.report.internal.html.ClassPage;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.NodePage;
import org.jacoco.report.internal.html.ReportPage;
import org.jacoco.report.internal.html.SourceFilePage;

public class PackagePage
extends NodePage {
    private final List<ClassPage> classes = new ArrayList<ClassPage>();
    private final Map<String, SourceFilePage> sourceFiles = new HashMap<String, SourceFilePage>();

    public PackagePage(ICoverageNode node, ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context) {
        super(node, parent, folder, context);
    }

    public IReportVisitor visitChild(ICoverageNode node) {
        ICoverageNode.ElementType type = node.getElementType();
        switch (type) {
            case SOURCEFILE: {
                SourceFilePage sourcePage = new SourceFilePage((ISourceFileCoverage)node, (ReportPage)this, this.folder, this.context);
                this.sourceFiles.put(node.getName(), sourcePage);
                return sourcePage;
            }
            case CLASS: {
                ClassPage classPage = new ClassPage((IClassCoverage)node, this, this.sourceFiles, this.folder, this.context);
                this.classes.add(classPage);
                return classPage;
            }
        }
        throw new AssertionError((Object)("Unexpected element type " + (Object)((Object)type)));
    }

    public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
        super.visitEnd(sourceFileLocator);
        this.classes.clear();
        this.sourceFiles.clear();
    }

    protected void headExtra(HTMLElement head) throws IOException {
        super.headExtra(head);
        head.script("text/javascript", this.context.getResources().getLink(this.folder, "sort.js"));
    }

    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    protected void content(HTMLElement body) throws IOException {
        this.context.getTable().render(body, this.classes, this.getNode(), this.context.getResources(), this.folder);
    }

    protected String getFileName() {
        return "index.html";
    }

    public String getLinkLabel() {
        return this.context.getLanguageNames().getPackageName(this.getNode().getName());
    }
}

