/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jaxrs.internal.configurators;

import java.io.File;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetInstallDataModelProvider;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.facets.FacetDetectorManager;
import org.eclipse.m2e.wtp.jaxrs.internal.MavenJaxRsConstants;
import org.eclipse.m2e.wtp.jaxrs.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JaxRsProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String WAR_PACKAGING = "war";
    private static final String M2E_JAXRS_ACTIVATION_PROPERTY = "m2e.jaxrs.activation";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        this.configureInternal(request.mavenProjectFacade(), monitor);
    }

    private void configureInternal(IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = mavenProjectFacade.getMavenProject(monitor);
        if (!this.isConfigurationEnabled(mavenProjectFacade, monitor)) {
            return;
        }
        IProject project = mavenProjectFacade.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj == null) {
            return;
        }
        if (!fproj.hasProjectFacet(WTPProjectsUtil.DYNAMIC_WEB_FACET) && !fproj.hasProjectFacet(WTPProjectsUtil.WEB_FRAGMENT_FACET) || fproj.hasProjectFacet(MavenJaxRsConstants.JAX_RS_FACET)) {
            return;
        }
        FacetDetectorManager facetDetectorManager = FacetDetectorManager.getInstance();
        IProjectFacetVersion jaxRsVersion = facetDetectorManager.findFacetVersion(mavenProjectFacade, MavenJaxRsConstants.JAX_RS_FACET.getId(), monitor);
        if (jaxRsVersion != null) {
            this.installJaxRsFacet(fproj, jaxRsVersion, mavenProject, monitor);
        }
    }

    private boolean isConfigurationEnabled(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        if (WTPProjectsUtil.isM2eWtpDisabled((IMavenProjectFacade)facade, (IProgressMonitor)monitor)) {
            return false;
        }
        Object pomActivationValue = facade.getMavenProject(monitor).getProperties().get(M2E_JAXRS_ACTIVATION_PROPERTY);
        boolean enabled = pomActivationValue == null ? MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().isEnabled(this.getId()) : Boolean.parseBoolean(pomActivationValue.toString());
        return enabled;
    }

    private void installJaxRsFacet(IFacetedProject fproj, IProjectFacetVersion facetVersion, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)fproj.getProject(), "org.eclipse.m2e.core.maven2Problem.wtp.jaxrs.configuration");
        IStatus status = facetVersion.getConstraint().check((Collection)fproj.getProjectFacets());
        if (status.isOK()) {
            ProjectUtils.refreshHierarchy((File)mavenProject.getBasedir(), (int)2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IDataModel model = this.createJaxRsDataModel(fproj, facetVersion);
            if (WAR_PACKAGING.equals(mavenProject.getPackaging())) {
                WarPluginConfiguration warConfig = new WarPluginConfiguration(mavenProject, fproj.getProject());
                String warSourceDirectory = warConfig.getWarSourceDirectory();
                model.setProperty("IJAXRSFacetInstallDataModelProperties.WEBCONTENT_DIR", (Object)warSourceDirectory);
            }
            model.setProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD", (Object)false);
            fproj.installProjectFacet(facetVersion, (Object)model, monitor);
        } else {
            String errorMessage = status.getMessage() == null ? Messages.JaxRsProjectConfigurator_Unknown_Error : status.getMessage();
            String markerMessage = NLS.bind((String)Messages.JaxrsProjectConfigurator_facet_cannot_be_installed, (Object)facetVersion, (Object)errorMessage);
            this.addErrorMarker(fproj.getProject(), markerMessage);
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus st = iStatusArray[n2];
                this.addErrorMarker(fproj.getProject(), st.getMessage());
                ++n2;
            }
        }
    }

    private IDataModel createJaxRsDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new JAXRSFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jaxrs-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        return config;
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.jaxrs.configuration", message, -1, 2);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            if (WTPProjectsUtil.isWTPProject((IProject)project)) {
                MavenProject oldProject;
                IMavenProjectFacade oldFacade = event.getOldMavenProject();
                if (oldFacade != null && (oldProject = oldFacade.getMavenProject(monitor)) != null && oldProject.getArtifacts().equals(mavenProject.getArtifacts())) {
                    return;
                }
                this.configureInternal(facade, monitor);
            }
        }
    }
}

