"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.MutableObservableValue = exports.staticObservableValue = void 0;
const event_1 = require("./event");
const lifecycle_1 = require("./lifecycle");
const staticObservableValue = (value) => ({
    onDidChange: event_1.Event.None,
    value,
});
exports.staticObservableValue = staticObservableValue;
class MutableObservableValue extends lifecycle_1.Disposable {
    constructor(_value) {
        super();
        this._value = _value;
        this.changeEmitter = this._register(new event_1.Emitter());
        this.onDidChange = this.changeEmitter.event;
    }
    get value() {
        return this._value;
    }
    set value(v) {
        if (v !== this._value) {
            this._value = v;
            this.changeEmitter.fire(v);
        }
    }
}
exports.MutableObservableValue = MutableObservableValue;
//# sourceMappingURL=observableValue.js.map