"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.BracketPairWithMinIndentationInfo = exports.BracketPairInfo = exports.BracketInfo = void 0;
class BracketInfo {
    constructor(range, 
    /** 0-based level */
    nestingLevel, isInvalid) {
        this.range = range;
        this.nestingLevel = nestingLevel;
        this.isInvalid = isInvalid;
    }
}
exports.BracketInfo = BracketInfo;
class BracketPairInfo {
    constructor(range, openingBracketRange, closingBracketRange, 
    /**
     * 0-based
    */
    nestingLevel) {
        this.range = range;
        this.openingBracketRange = openingBracketRange;
        this.closingBracketRange = closingBracketRange;
        this.nestingLevel = nestingLevel;
    }
}
exports.BracketPairInfo = BracketPairInfo;
class BracketPairWithMinIndentationInfo extends BracketPairInfo {
    constructor(range, openingBracketRange, closingBracketRange, 
    /**
     * 0-based
    */
    nestingLevel, 
    /**
     * -1 if not requested, otherwise the size of the minimum indentation in the bracket pair in terms of visible columns.
    */
    minVisibleColumnIndentation) {
        super(range, openingBracketRange, closingBracketRange, nestingLevel);
        this.minVisibleColumnIndentation = minVisibleColumnIndentation;
    }
}
exports.BracketPairWithMinIndentationInfo = BracketPairWithMinIndentationInfo;
//# sourceMappingURL=textModelBracketPairs.js.map