"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractSelection = exports.withSelection = exports.matchesSomeScheme = exports.matchesScheme = exports.NullOpenerService = exports.IOpenerService = void 0;
const lifecycle_1 = require("../../../base/common/lifecycle");
const strings_1 = require("../../../base/common/strings");
const uri_1 = require("../../../base/common/uri");
const instantiation_1 = require("../../instantiation/common/instantiation");
exports.IOpenerService = (0, instantiation_1.createDecorator)('openerService');
exports.NullOpenerService = Object.freeze({
    _serviceBrand: undefined,
    registerOpener() { return lifecycle_1.Disposable.None; },
    registerValidator() { return lifecycle_1.Disposable.None; },
    registerExternalUriResolver() { return lifecycle_1.Disposable.None; },
    setDefaultExternalOpener() { },
    registerExternalOpener() { return lifecycle_1.Disposable.None; },
    open() {
        return __awaiter(this, void 0, void 0, function* () { return false; });
    },
    resolveExternalUri(uri) {
        return __awaiter(this, void 0, void 0, function* () { return { resolved: uri, dispose() { } }; });
    },
});
function matchesScheme(target, scheme) {
    if (uri_1.URI.isUri(target)) {
        return (0, strings_1.equalsIgnoreCase)(target.scheme, scheme);
    }
    else {
        return (0, strings_1.startsWithIgnoreCase)(target, scheme + ':');
    }
}
exports.matchesScheme = matchesScheme;
function matchesSomeScheme(target, ...schemes) {
    return schemes.some(scheme => matchesScheme(target, scheme));
}
exports.matchesSomeScheme = matchesSomeScheme;
/**
 * Encodes selection into the `URI`.
 *
 * IMPORTANT: you MUST use `extractSelection` to separate the selection
 * again from the original `URI` before passing the `URI` into any
 * component that is not aware of selections.
 */
function withSelection(uri, selection) {
    return uri.with({ fragment: `${selection.startLineNumber},${selection.startColumn}${selection.endLineNumber ? `-${selection.endLineNumber}${selection.endColumn ? `,${selection.endColumn}` : ''}` : ''}` });
}
exports.withSelection = withSelection;
/**
 * file:///some/file.js#73
 * file:///some/file.js#L73
 * file:///some/file.js#73,84
 * file:///some/file.js#L73,84
 * file:///some/file.js#73-83
 * file:///some/file.js#L73-L83
 * file:///some/file.js#73,84-83,52
 * file:///some/file.js#L73,84-L83,52
 */
function extractSelection(uri) {
    let selection = undefined;
    const match = /^L?(\d+)(?:,(\d+))?(-L?(\d+)(?:,(\d+))?)?/.exec(uri.fragment);
    if (match) {
        selection = {
            startLineNumber: parseInt(match[1]),
            startColumn: match[2] ? parseInt(match[2]) : 1,
            endLineNumber: match[4] ? parseInt(match[4]) : undefined,
            endColumn: match[4] ? (match[5] ? parseInt(match[5]) : 1) : undefined
        };
        uri = uri.with({ fragment: '' });
    }
    return { selection, uri };
}
exports.extractSelection = extractSelection;
//# sourceMappingURL=opener.js.map