"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
const jsdom_1 = require("@theia/core/lib/browser/test/jsdom");
let disableJSDOM = (0, jsdom_1.enableJSDOM)();
const frontend_application_config_provider_1 = require("@theia/core/lib/browser/frontend-application-config-provider");
const application_props_1 = require("@theia/application-package/lib/application-props");
frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(Object.assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config));
const chai_1 = require("chai");
const os_1 = require("@theia/core/lib/common/os");
const workspace_frontend_contribution_1 = require("./workspace-frontend-contribution");
const workspace_commands_1 = require("./workspace-commands");
disableJSDOM();
describe('workspace-frontend-contribution', () => {
    describe('WorkspaceFrontendContribution', () => {
        const title = workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE.dialogLabel;
        const filters = workspace_frontend_contribution_1.WorkspaceFrontendContribution.DEFAULT_FILE_FILTER;
        before(() => disableJSDOM = (0, jsdom_1.enableJSDOM)());
        after(() => disableJSDOM());
        [
            [os_1.OS.Type.Linux, 'browser', true, { title, canSelectFiles: true, canSelectFolders: true, filters }],
            [os_1.OS.Type.Linux, 'browser', false, { title, canSelectFiles: false, canSelectFolders: true }],
            [os_1.OS.Type.Linux, 'electron', true, { title, canSelectFiles: true, canSelectFolders: false, filters }],
            [os_1.OS.Type.Linux, 'electron', false, { title, canSelectFiles: false, canSelectFolders: true }],
            [os_1.OS.Type.Windows, 'browser', true, { title, canSelectFiles: true, canSelectFolders: true, filters }],
            [os_1.OS.Type.Windows, 'browser', false, { title, canSelectFiles: false, canSelectFolders: true }],
            [os_1.OS.Type.Windows, 'electron', true, { title, canSelectFiles: true, canSelectFolders: false, filters }],
            [os_1.OS.Type.Windows, 'electron', false, { title, canSelectFiles: false, canSelectFolders: true }],
            [os_1.OS.Type.OSX, 'browser', true, { title, canSelectFiles: true, canSelectFolders: true, filters }],
            [os_1.OS.Type.OSX, 'browser', false, { title, canSelectFiles: false, canSelectFolders: true }],
            [os_1.OS.Type.OSX, 'electron', true, { title, canSelectFiles: true, canSelectFolders: true, filters }],
            [os_1.OS.Type.OSX, 'electron', false, { title, canSelectFiles: true, canSelectFolders: true, filters }]
        ].forEach(test => {
            const [type, environment, supportMultiRootWorkspace, expected] = test;
            const electron = environment === 'electron' ? true : false;
            const os = os_1.OS.Type[type]; // eslint-disable-line @typescript-eslint/no-explicit-any
            const actual = workspace_frontend_contribution_1.WorkspaceFrontendContribution.createOpenWorkspaceOpenFileDialogProps({
                type,
                electron,
                supportMultiRootWorkspace
            });
            it(`createOpenWorkspaceOpenFileDialogProps - OS: ${os}, Environment: ${environment}, Multi-root workspace: ${supportMultiRootWorkspace ? 'yes' : 'no'}`, () => {
                (0, chai_1.expect)(actual).to.be.deep.equal(expected);
            });
        });
    });
});
//# sourceMappingURL=workspace-frontend-contribution.spec.js.map