"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionHTMLProps = exports.htmlImageProps = exports.htmlInputProps = exports.htmlInputEvents = exports.htmlInputAttrs = void 0;

var _includes2 = _interopRequireDefault(require("lodash/includes"));

var _forEach2 = _interopRequireDefault(require("lodash/forEach"));

var htmlInputAttrs = [// REACT
'selected', 'defaultValue', 'defaultChecked', // LIMITED HTML PROPS
'accept', 'autoCapitalize', 'autoComplete', 'autoCorrect', 'autoFocus', 'checked', 'disabled', 'form', 'id', 'lang', 'list', 'max', 'maxLength', 'min', 'minLength', 'multiple', 'name', 'pattern', 'placeholder', 'readOnly', 'required', 'step', 'title', 'type', 'value'];
exports.htmlInputAttrs = htmlInputAttrs;
var htmlInputEvents = [// EVENTS
// keyboard
'onKeyDown', 'onKeyPress', 'onKeyUp', // focus
'onFocus', 'onBlur', // form
'onChange', 'onInput', // mouse
'onClick', 'onContextMenu', 'onDrag', 'onDragEnd', 'onDragEnter', 'onDragExit', 'onDragLeave', 'onDragOver', 'onDragStart', 'onDrop', 'onMouseDown', 'onMouseEnter', 'onMouseLeave', 'onMouseMove', 'onMouseOut', 'onMouseOver', 'onMouseUp', // selection
'onSelect', // touch
'onTouchCancel', 'onTouchEnd', 'onTouchMove', 'onTouchStart'];
exports.htmlInputEvents = htmlInputEvents;
var htmlInputProps = htmlInputAttrs.concat(htmlInputEvents);
exports.htmlInputProps = htmlInputProps;
var htmlImageProps = ['alt', 'height', 'src', 'srcSet', 'width'];
/**
 * Returns an array of objects consisting of: props of html input element and rest.
 * @param {object} props A ReactElement props object
 * @param {Object} [options={}]
 * @param {Array} [options.htmlProps] An array of html input props
 * @param {boolean} [options.includeAria] Includes all input props that starts with "aria-"
 * @returns {[{}, {}]} An array of objects
 */

exports.htmlImageProps = htmlImageProps;

var partitionHTMLProps = function partitionHTMLProps(props) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$htmlProps = options.htmlProps,
      htmlProps = _options$htmlProps === void 0 ? htmlInputProps : _options$htmlProps,
      _options$includeAria = options.includeAria,
      includeAria = _options$includeAria === void 0 ? true : _options$includeAria;
  var inputProps = {};
  var rest = {};
  (0, _forEach2.default)(props, function (val, prop) {
    var possibleAria = includeAria && (/^aria-.*$/.test(prop) || prop === 'role');
    var target = (0, _includes2.default)(htmlProps, prop) || possibleAria ? inputProps : rest;
    target[prop] = val;
  });
  return [inputProps, rest];
};

exports.partitionHTMLProps = partitionHTMLProps;