"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceServerConnectionStatusService = void 0;
/* eslint-disable @typescript-eslint/no-non-null-assertion */
const inversify_1 = require("inversify");
const rest_client_1 = require("tsp-typescript-client/lib/protocol/rest-client");
let TraceServerConnectionStatusService = class TraceServerConnectionStatusService {
    constructor() {
        this.connectionStatusListener = ((status) => {
            if (status) {
                this.renderSuccess();
            }
            else {
                this.renderFailure();
            }
        });
    }
    addConnectionStatusListener() {
        rest_client_1.RestClient.addConnectionStatusListener(this.connectionStatusListener);
    }
    removeConnectionStatusListener() {
        rest_client_1.RestClient.removeConnectionStatusListener(this.connectionStatusListener);
    }
    renderSuccess() {
        if (document.getElementById('trace.viewer.serverCheck')) {
            document.getElementById('trace.viewer.serverCheck').className = 'fa fa-check-circle-o fa-lg';
            document.getElementById('trace.viewer.serverCheck').title = 'Server health and latency are good. No known issues';
            document.getElementById('trace.viewer.serverCheck').style.color = 'green';
        }
    }
    renderFailure() {
        if (document.getElementById('trace.viewer.serverCheck')) {
            document.getElementById('trace.viewer.serverCheck').className = 'fa fa-times-circle-o fa-lg';
            document.getElementById('trace.viewer.serverCheck').title = 'Trace Viewer Critical Error: Trace Server Offline';
            document.getElementById('trace.viewer.serverCheck').style.color = 'red';
        }
    }
};
TraceServerConnectionStatusService = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], TraceServerConnectionStatusService);
exports.TraceServerConnectionStatusService = TraceServerConnectionStatusService;
//# sourceMappingURL=trace-server-status.js.map