"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var time_graph_axis_scale_1 = require("../time-graph-axis-scale");
var time_graph_unit_controller_1 = require("../../time-graph-unit-controller");
var time_graph_state_controller_1 = require("../../time-graph-state-controller");
describe('TimeGraphAxisScale', function () {
    var unitController = new time_graph_unit_controller_1.TimeGraphUnitController(BigInt(0), { start: BigInt(0), end: BigInt(1) });
    var canvas = document.createElement("canvas");
    var stateController = new time_graph_state_controller_1.TimeGraphStateController(canvas, unitController);
    var style = {
        position: { x: 0, y: 0 },
        width: 100,
        height: 100,
        lineColor: 111
    };
    var component = new time_graph_axis_scale_1.TimeGraphAxisScale('Test', style, unitController, stateController);
    it('Renders', function () {
        expect(component).toBeTruthy();
    });
    it('Updates options', function () {
        var spy = jest.spyOn(component, 'update');
        var updatedStyle = {
            position: { x: 10, y: 10 },
            width: 200,
            height: 200,
            lineColor: 222
        };
        component.update(updatedStyle);
        expect(spy).toHaveBeenCalled();
        spy.mockRestore();
    });
});
//# sourceMappingURL=time-graph-axis-scale.test.js.map