"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChart = exports.keyBoardNavs = void 0;
var time_graph_annotation_1 = require("../components/time-graph-annotation");
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_row_1 = require("../components/time-graph-row");
var time_graph_state_1 = require("../components/time-graph-state");
var time_graph_chart_layer_1 = require("./time-graph-chart-layer");
var bigint_utils_1 = require("../bigint-utils");
var lodash_1 = require("lodash");
exports.keyBoardNavs = {
    "zoomin": ['w', 'i'],
    "zoomout": ['s', 'k'],
    "panleft": ['a', 'j'],
    "panright": ['d', 'l']
};
var TimeGraphChart = /** @class */ (function (_super) {
    __extends(TimeGraphChart, _super);
    function TimeGraphChart(id, providers, rowController) {
        var _this = _super.call(this, id, rowController) || this;
        _this.providers = providers;
        _this.rowController = rowController;
        _this.selectedElementChangedHandler = [];
        _this.mousePanning = false;
        _this.mouseZooming = false;
        _this.mouseButtons = 0;
        _this._debouncedMaybeFetchNewData = (0, lodash_1.debounce)(function () { return _this.maybeFetchNewData(); }, 400);
        // Keep track of the most recently clicked point.
        // If clicked again during _multiClickTime duration (milliseconds) record multi-click
        _this._recentlyClickedGlobal = null;
        _this._multiClickTime = 500;
        _this._mouseClicks = 0;
        _this.providedRange = { start: BigInt(0), end: BigInt(0) };
        _this.providedResolution = 1;
        _this.isNavigating = false;
        return _this;
    }
    TimeGraphChart.prototype.adjustZoom = function (zoomPosition, hasZoomedIn) {
        if (this.unitController.viewRangeLength <= 0) {
            return;
        }
        if (zoomPosition === undefined) {
            var start_1 = this.getPixel(this.unitController.selectionRange ? this.unitController.selectionRange.start - this.unitController.viewRange.start : BigInt(0));
            var end_1 = this.getPixel(this.unitController.selectionRange ? this.unitController.selectionRange.end - this.unitController.viewRange.start : this.unitController.viewRangeLength);
            zoomPosition = (start_1 + end_1) / 2;
        }
        var zoomTime = zoomPosition / this.stateController.zoomFactor;
        var zoomMagnitude = hasZoomedIn ? 0.8 : 1.25;
        var newViewRangeLength = bigint_utils_1.BIMath.clamp(Number(this.unitController.viewRangeLength) * zoomMagnitude, BigInt(2), this.unitController.absoluteRange);
        var center = this.unitController.viewRange.start + bigint_utils_1.BIMath.round(zoomTime);
        var start = bigint_utils_1.BIMath.clamp(Number(center) - zoomTime * Number(newViewRangeLength) / Number(this.unitController.viewRangeLength), BigInt(0), this.unitController.absoluteRange - newViewRangeLength);
        var end = start + newViewRangeLength;
        if (start !== end) {
            this.unitController.viewRange = {
                start: start,
                end: end
            };
        }
    };
    ;
    TimeGraphChart.prototype.afterAddToContainer = function () {
        var _this = this;
        this.stage.cursor = 'default';
        var mousePositionX = 1;
        var horizontalDelta = 3;
        var triggerKeyEvent = false;
        var moveHorizontally = function (magnitude) {
            if (magnitude === 0) {
                return;
            }
            // move by at least one nanosecond
            var absOffset = bigint_utils_1.BIMath.max(1, Math.abs(magnitude / _this.stateController.zoomFactor));
            var timeOffset = magnitude > 0 ? absOffset : -absOffset;
            var start = bigint_utils_1.BIMath.clamp(_this.unitController.viewRange.start + timeOffset, BigInt(0), _this.unitController.absoluteRange - _this.unitController.viewRangeLength);
            var end = start + _this.unitController.viewRangeLength;
            _this.unitController.viewRange = {
                start: start,
                end: end
            };
        };
        var panHorizontally = function (magnitude) {
            var timeOffset = bigint_utils_1.BIMath.round(magnitude / _this.stateController.zoomFactor);
            var start = bigint_utils_1.BIMath.clamp(_this.mousePanningStart - timeOffset, BigInt(0), _this.unitController.absoluteRange - _this.unitController.viewRangeLength);
            var end = start + _this.unitController.viewRangeLength;
            _this.unitController.viewRange = {
                start: start,
                end: end
            };
        };
        var moveVertically = function (magnitude) {
            if (_this.rowController.totalHeight <= _this.stateController.canvasDisplayHeight) {
                return;
            }
            var verticalOffset = Math.max(0, _this.rowController.verticalOffset + magnitude);
            if (_this.rowController.totalHeight - verticalOffset <= _this.stateController.canvasDisplayHeight) {
                verticalOffset = _this.rowController.totalHeight - _this.stateController.canvasDisplayHeight;
            }
            _this.rowController.verticalOffset = verticalOffset;
        };
        this._mouseMoveHandler = function (event) {
            mousePositionX = event.offsetX;
        };
        this._keyDownHandler = function (event) {
            var keyPressed = event.key;
            if (triggerKeyEvent) {
                if (keyPressed === 'Control' && _this.mouseButtons === 0 && !event.shiftKey && !event.altKey) {
                    _this.stage.cursor = 'grabbing';
                }
                else if (_this.stage.cursor === 'grabbing' && !_this.mousePanning &&
                    (keyPressed === 'Shift' || keyPressed === 'Alt')) {
                    _this.stage.cursor = 'default';
                }
                if (exports.keyBoardNavs['zoomin'].indexOf(keyPressed) >= 0) {
                    _this.adjustZoom(mousePositionX, true);
                }
                else if (exports.keyBoardNavs['zoomout'].indexOf(keyPressed) >= 0) {
                    _this.adjustZoom(mousePositionX, false);
                }
                else if (exports.keyBoardNavs['panleft'].indexOf(keyPressed) >= 0) {
                    moveHorizontally(-horizontalDelta);
                }
                else if (exports.keyBoardNavs['panright'].indexOf(keyPressed) >= 0) {
                    moveHorizontally(horizontalDelta);
                }
                event.preventDefault();
            }
            if (keyPressed === 'Escape' && _this.mouseZooming) {
                _this.mouseZooming = false;
                _this.stage.cursor = 'default';
                _this.updateZoomingSelection();
            }
        };
        this._keyUpHandler = function (event) {
            var keyPressed = event.key;
            if (triggerKeyEvent) {
                if (_this.stage.cursor === 'grabbing' && !_this.mousePanning && keyPressed === 'Control') {
                    _this.stage.cursor = 'default';
                }
            }
        };
        this.stage.addListener('mouseover', function (event) {
            triggerKeyEvent = true;
        });
        this.stage.addListener('mouseout', function (event) {
            triggerKeyEvent = false;
            if (_this.stage.cursor === 'grabbing' && !_this.mousePanning) {
                _this.stage.cursor = 'default';
            }
        });
        this._stageMouseDownHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            // if only middle button or only Ctrl+left button is pressed
            if ((event.data.button !== 1 || event.data.buttons !== 4) &&
                (event.data.button !== 0 || event.data.buttons !== 1 ||
                    !event.data.originalEvent.ctrlKey ||
                    event.data.originalEvent.shiftKey ||
                    event.data.originalEvent.altKey ||
                    _this.stage.cursor !== 'grabbing')) {
                return;
            }
            _this.mousePanning = true;
            _this.mouseDownButton = event.data.button;
            _this.mouseStartX = event.data.global.x;
            _this.mousePanningStart = _this.unitController.viewRange.start;
            _this.stage.cursor = 'grabbing';
        };
        this.stage.on('mousedown', this._stageMouseDownHandler);
        this._stageMouseMoveHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (_this.mousePanning) {
                if ((_this.mouseDownButton == 1 && (_this.mouseButtons & 4) === 0) ||
                    (_this.mouseDownButton == 0 && (_this.mouseButtons & 1) === 0)) {
                    // handle missed button mouseup event
                    _this.mousePanning = false;
                    var orig = event.data.originalEvent;
                    if (!orig.ctrlKey || orig.shiftKey || orig.altKey) {
                        _this.stage.cursor = 'default';
                    }
                    return;
                }
                var horizontalDelta_1 = event.data.global.x - _this.mouseStartX;
                panHorizontally(horizontalDelta_1);
            }
            if (_this.mouseZooming) {
                _this.mouseEndX = event.data.global.x;
                _this.updateZoomingSelection();
            }
        };
        this.stage.on('mousemove', this._stageMouseMoveHandler);
        this._stageMouseUpHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (event.data.button === _this.mouseDownButton && _this.mousePanning) {
                _this.mousePanning = false;
                var orig = event.data.originalEvent;
                if (!orig.ctrlKey || orig.shiftKey || orig.altKey) {
                    _this.stage.cursor = 'default';
                }
            }
        };
        this.stage.on('mouseup', this._stageMouseUpHandler);
        this.stage.on('mouseupoutside', this._stageMouseUpHandler);
        this._mouseWheelHandler = function (ev) {
            if (ev.ctrlKey) {
                var hasZoomedIn = ev.deltaY < 0;
                _this.adjustZoom(ev.offsetX, hasZoomedIn);
            }
            else if (ev.shiftKey) {
                moveHorizontally(ev.deltaY);
            }
            else {
                if (Math.abs(ev.deltaY) > Math.abs(ev.deltaX)) {
                    moveVertically(ev.deltaY);
                }
                else {
                    moveHorizontally(ev.deltaX);
                }
            }
            ev.preventDefault();
        };
        this._contextMenuHandler = function (e) {
            e.preventDefault();
        };
        this._mouseDownHandler = function (e) {
            _this.mouseButtons = e.buttons;
            // if only right button is pressed
            if (e.button === 2 && e.buttons === 2 && _this.stage.cursor === 'default') {
                _this.mouseZooming = true;
                _this.mouseDownButton = e.button;
                _this.mouseStartX = e.offsetX;
                _this.mouseEndX = e.offsetX;
                _this.mouseZoomingStart = _this.unitController.viewRange.start + bigint_utils_1.BIMath.round(_this.mouseStartX / _this.stateController.zoomFactor);
                _this.stage.cursor = 'col-resize';
                // this is the only way to detect mouseup outside of right button
                document.addEventListener('mouseup', mouseUpListener);
                _this.updateZoomingSelection();
            }
        };
        var mouseUpListener = function (e) {
            _this.mouseButtons = e.buttons;
            if (e.button === _this.mouseDownButton && _this.mouseZooming) {
                _this.mouseZooming = false;
                var start = _this.mouseZoomingStart;
                var end = _this.unitController.viewRange.start + bigint_utils_1.BIMath.round(_this.mouseEndX / _this.stateController.zoomFactor);
                if (bigint_utils_1.BIMath.abs(end - start) > 1 && _this.unitController.viewRangeLength > 1) {
                    var newViewStart = bigint_utils_1.BIMath.clamp(start, _this.unitController.viewRange.start, end);
                    var newViewEnd = bigint_utils_1.BIMath.clamp(end, start, _this.unitController.viewRange.end);
                    _this.unitController.viewRange = {
                        start: newViewStart,
                        end: newViewEnd
                    };
                }
                _this.stage.cursor = 'default';
                document.removeEventListener('mouseup', mouseUpListener);
                _this.updateZoomingSelection();
            }
        };
        this.onCanvasEvent('mousemove', this._mouseMoveHandler);
        this.onCanvasEvent('keydown', this._keyDownHandler);
        this.onCanvasEvent('keyup', this._keyUpHandler);
        this.onCanvasEvent('mousedown', this._mouseDownHandler);
        this.onCanvasEvent('mousewheel', this._mouseWheelHandler);
        this.onCanvasEvent('wheel', this._mouseWheelHandler);
        this.onCanvasEvent('contextmenu', this._contextMenuHandler);
        this.rowController.onVerticalOffsetChangedHandler(function (verticalOffset) {
            _this.layer.position.y = -verticalOffset;
        });
        this._viewRangeChangedHandler = function () {
            _this.updateScaleAndPosition();
            if (_this.mouseZooming) {
                _this.updateZoomingSelection();
            }
        };
        this.unitController.onViewRangeChanged(this._viewRangeChangedHandler);
        this.unitController.onViewRangeChanged(this._debouncedMaybeFetchNewData);
        if (this.unitController.viewRangeLength && this.stateController.canvasDisplayWidth) {
            this.maybeFetchNewData();
        }
    };
    TimeGraphChart.prototype.updateChart = function () {
        var update = true;
        if (this.unitController && this.stateController) {
            this.maybeFetchNewData(update);
        }
    };
    TimeGraphChart.prototype.update = function () {
        this.updateScaleAndPosition();
        this._debouncedMaybeFetchNewData();
    };
    TimeGraphChart.prototype.updateZoomingSelection = function () {
        if (this.zoomingSelection) {
            this.removeChild(this.zoomingSelection);
            delete this.zoomingSelection;
        }
        if (this.mouseZooming) {
            var mouseStartX = Number(this.mouseZoomingStart - this.unitController.viewRange.start) * this.stateController.zoomFactor;
            this.zoomingSelection = new time_graph_rectangle_1.TimeGraphRectangle({
                color: 0xbbbbbb,
                opacity: 0.2,
                position: {
                    x: mouseStartX,
                    y: 0
                },
                height: Math.max(this.stateController.canvasDisplayHeight, this.rowController.totalHeight),
                width: this.mouseEndX - mouseStartX
            });
            this.addChild(this.zoomingSelection);
        }
    };
    TimeGraphChart.prototype.destroy = function () {
        this.unitController.removeViewRangeChangedHandler(this._debouncedMaybeFetchNewData);
        if (this._viewRangeChangedHandler) {
            this.unitController.removeViewRangeChangedHandler(this._viewRangeChangedHandler);
        }
        if (this._mouseMoveHandler) {
            this.removeOnCanvasEvent('mousemove', this._mouseMoveHandler);
        }
        if (this._mouseDownHandler) {
            this.removeOnCanvasEvent('mousedown', this._mouseDownHandler);
        }
        if (this._keyDownHandler) {
            this.removeOnCanvasEvent('keydown', this._keyDownHandler);
        }
        if (this._keyUpHandler) {
            this.removeOnCanvasEvent('keyup', this._keyUpHandler);
        }
        if (this._mouseWheelHandler) {
            this.removeOnCanvasEvent('mousewheel', this._mouseWheelHandler);
            this.removeOnCanvasEvent('wheel', this._mouseWheelHandler);
        }
        if (this._contextMenuHandler) {
            this.removeOnCanvasEvent('contextmenu', this._contextMenuHandler);
        }
        if (this.stage) {
            this.stage.off('mousedown', this._stageMouseDownHandler);
            this.stage.off('mousemove', this._stageMouseMoveHandler);
            this.stage.off('mouseup', this._stageMouseUpHandler);
            this.stage.off('mouseupoutside', this._stageMouseUpHandler);
        }
        _super.prototype.destroy.call(this);
    };
    TimeGraphChart.prototype.maybeFetchNewData = function (update) {
        return __awaiter(this, void 0, void 0, function () {
            var resolution, viewRange, request, rowData;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        resolution = Number(this.unitController.viewRangeLength) / this.stateController.canvasDisplayWidth;
                        viewRange = this.unitController.viewRange;
                        if (!(viewRange && (viewRange.start < this.providedRange.start ||
                            viewRange.end > this.providedRange.end ||
                            resolution != this.providedResolution ||
                            update))) return [3 /*break*/, 4];
                        request = { viewRange: viewRange, resolution: resolution };
                        if ((0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            // request ignored because equal to ongoing request
                            return [2 /*return*/];
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, , 3, 4]);
                        this.ongoingRequest = request;
                        return [4 /*yield*/, this.providers.dataProvider(viewRange, resolution)];
                    case 2:
                        rowData = _a.sent();
                        if (!(0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            // response discarded because not equal to ongoing request
                            return [2 /*return*/];
                        }
                        if (rowData) {
                            this.providedResolution = rowData.resolution;
                            this.providedRange = rowData.range;
                            this.setRowModel(rowData.rows);
                            this.removeChildren();
                            this.addRows(this.rows, this.rowController.rowHeight);
                            if (this.isNavigating) {
                                this.selectStateInNavigation();
                            }
                            if (this.mouseZooming) {
                                delete this.zoomingSelection;
                                this.updateZoomingSelection();
                            }
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        if ((0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            this.ongoingRequest = undefined;
                        }
                        this.isNavigating = false;
                        return [7 /*endfinally*/];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    TimeGraphChart.prototype.updateScaleAndPosition = function () {
        var _this = this;
        if (this.rows) {
            this.rows.forEach(function (row) {
                var rowComponent = _this.rowComponents.get(row);
                if (rowComponent) {
                    var opts = {
                        height: _this.rowController.rowHeight,
                        position: {
                            x: 0,
                            y: rowComponent.position.y
                        },
                        width: _this.stateController.canvasDisplayWidth
                    };
                    rowComponent.update(opts);
                }
                var lastX;
                var lastTime;
                var lastBlank = false;
                row.states.forEach(function (state, elementIndex) {
                    var _a;
                    var el = _this.rowStateComponents.get(state);
                    var start = state.range.start;
                    var xStart = _this.getPixel(start - _this.unitController.viewRange.start);
                    if (el) {
                        var end = state.range.end;
                        var xEnd = _this.getPixel(end - _this.unitController.viewRange.start);
                        var opts = {
                            height: el.height,
                            position: {
                                x: xStart,
                                y: el.position.y
                            },
                            width: Math.max(1, xEnd - xStart),
                            displayWidth: _this.getPixel(bigint_utils_1.BIMath.min(_this.unitController.viewRange.end, end)) - _this.getPixel(bigint_utils_1.BIMath.max(_this.unitController.viewRange.start, start))
                        };
                        el.update(opts);
                    }
                    if (rowComponent && row.gapStyle) {
                        _this.updateGap(state, rowComponent, row.gapStyle, xStart, lastX, lastTime, lastBlank);
                    }
                    lastX = Math.max(xStart + 1, _this.getPixel(state.range.end - _this.unitController.viewRange.start));
                    lastTime = state.range.end;
                    lastBlank = (((_a = state.data) === null || _a === void 0 ? void 0 : _a.style) === undefined);
                });
                row.annotations.forEach(function (annotation, elementIndex) {
                    var el = _this.rowAnnotationComponents.get(annotation);
                    if (el) {
                        // only handle ticks for now
                        var start = annotation.range.start;
                        var opts = {
                            position: {
                                x: _this.getPixel(start - _this.unitController.viewRange.start),
                                y: el.displayObject.y
                            }
                        };
                        el.update(opts);
                    }
                });
            });
        }
    };
    TimeGraphChart.prototype.handleSelectedStateChange = function () {
        var _this = this;
        this.selectedElementChangedHandler.forEach(function (handler) { return handler(_this.selectedStateModel); });
    };
    TimeGraphChart.prototype.addRow = function (row, height, rowIndex) {
        var _this = this;
        var rowId = 'row_' + rowIndex;
        var rowStyle = this.providers.rowStyleProvider ? this.providers.rowStyleProvider(row) : undefined;
        var rowComponent = new time_graph_row_1.TimeGraphRow(rowId, {
            position: {
                x: 0,
                y: (height * rowIndex)
            },
            width: this.stateController.canvasDisplayWidth,
            height: height
        }, rowIndex, row, rowStyle);
        rowComponent.displayObject.interactive = true;
        rowComponent.displayObject.on('click', (function (e) {
            _this.selectRow(row);
        }).bind(this));
        this.addChild(rowComponent);
        this.rowComponents.set(row, rowComponent);
        if (this.rowController.selectedRow && this.rowController.selectedRow.id === row.id) {
            this.selectRow(row);
        }
        var lastX;
        var lastTime;
        var lastBlank = false;
        row.states.forEach(function (stateModel) {
            var _a, _b;
            var x = _this.getPixel(stateModel.range.start - _this.unitController.viewRange.start);
            if ((_a = stateModel.data) === null || _a === void 0 ? void 0 : _a.style) {
                var el = _this.createNewState(stateModel, rowComponent);
                if (el) {
                    _this.addElementInteractions(el);
                    _this.addChild(el);
                    if (_this.selectedStateModel && _this.rowController.selectedRow
                        && _this.rowController.selectedRow.id === row.id
                        && _this.selectedStateModel.range.start === el.model.range.start
                        && _this.selectedStateModel.range.end === el.model.range.end) {
                        _this.selectState(el.model);
                    }
                }
            }
            if (row.gapStyle) {
                _this.updateGap(stateModel, rowComponent, row.gapStyle, x, lastX, lastTime, lastBlank);
            }
            lastX = Math.max(x + 1, _this.getPixel(stateModel.range.end - _this.unitController.viewRange.start));
            lastTime = stateModel.range.end;
            lastBlank = (((_b = stateModel.data) === null || _b === void 0 ? void 0 : _b.style) === undefined);
        });
        row.annotations.forEach(function (annotation) {
            var el = _this.createNewAnnotation(annotation, rowComponent);
            if (el) {
                _this.addElementInteractions(el);
                _this.addChild(el);
            }
        });
    };
    TimeGraphChart.prototype.updateGap = function (state, rowComponent, gapStyle, x, lastX, lastTime, lastBlank) {
        var _a, _b, _c, _d;
        /* add gap if there is visible space between states or if there is a time gap between two blank states */
        if (lastX && lastTime && (x > lastX || (lastBlank && !((_a = state.data) === null || _a === void 0 ? void 0 : _a.style) && state.range.start > lastTime))) {
            var gap = (_b = state.data) === null || _b === void 0 ? void 0 : _b.gap;
            if (gap) {
                var width = Math.max(1, x - lastX);
                var opts = {
                    height: gap.height,
                    position: {
                        x: lastX,
                        y: gap.position.y
                    },
                    width: width,
                    displayWidth: width
                };
                gap.update(opts);
            }
            else {
                var stateModel = {
                    id: rowComponent.id + '-gap',
                    range: {
                        start: lastTime,
                        end: state.range.start
                    },
                    data: {
                        style: gapStyle
                    }
                };
                var gap_1 = this.createNewState(stateModel, rowComponent);
                if (gap_1) {
                    this.addChild(gap_1);
                    if (state.data) {
                        state.data['gap'] = gap_1;
                    }
                }
            }
        }
        else {
            if (state.data && ((_c = state.data) === null || _c === void 0 ? void 0 : _c.gap)) {
                this.removeChild((_d = state.data) === null || _d === void 0 ? void 0 : _d.gap);
                state.data.gap = undefined;
            }
        }
    };
    TimeGraphChart.prototype.createNewAnnotation = function (annotation, rowComponent) {
        var start = this.getPixel(annotation.range.start - this.unitController.viewRange.start);
        var el;
        var elementStyle = this.providers.rowAnnotationStyleProvider ? this.providers.rowAnnotationStyleProvider(annotation) : undefined;
        el = new time_graph_annotation_1.TimeGraphAnnotationComponent(annotation.id, annotation, { position: { x: start, y: rowComponent.position.y + (rowComponent.height * 0.5) } }, elementStyle, rowComponent);
        this.rowAnnotationComponents.set(annotation, el);
        return el;
    };
    TimeGraphChart.prototype.createNewState = function (stateModel, rowComponent) {
        var xStart = this.getPixel(stateModel.range.start - this.unitController.viewRange.start);
        var xEnd = this.getPixel(stateModel.range.end - this.unitController.viewRange.start);
        var el;
        var displayStart = this.getPixel(bigint_utils_1.BIMath.max(stateModel.range.start, this.unitController.viewRange.start));
        var displayEnd = this.getPixel(bigint_utils_1.BIMath.min(stateModel.range.end, this.unitController.viewRange.end));
        var displayWidth = displayEnd - displayStart;
        var elementStyle = this.providers.stateStyleProvider ? this.providers.stateStyleProvider(stateModel) : undefined;
        el = new time_graph_state_1.TimeGraphStateComponent(stateModel.id, stateModel, xStart, xEnd, rowComponent, elementStyle, displayWidth);
        this.rowStateComponents.set(stateModel, el);
        return el;
    };
    TimeGraphChart.prototype.addElementInteractions = function (el) {
        var _this = this;
        el.displayObject.interactive = true;
        var self = this;
        this._multiClickTimer = (0, lodash_1.debounce)(function () {
            self._mouseClicks = 0;
            self._recentlyClickedGlobal = null;
        }, this._multiClickTime);
        el.displayObject.on('click', (function (e) {
            if (el instanceof time_graph_state_1.TimeGraphStateComponent && !_this.mousePanning && !_this.mouseZooming) {
                _this.selectState(el.model);
            }
            // Mouse clicks count keeps increasing without limit as long as we keep clicking on the same coordinate.
            if (_this._recentlyClickedGlobal && (_this._recentlyClickedGlobal.equals(e.data.global))) {
                _this._mouseClicks++;
            }
            else {
                // Only clear the timer and reset the click count if the global position is NOT 
                // the same one as click 1.
                _this._multiClickTimer.cancel();
                _this._mouseClicks = 1;
                // Store the global position on first click
                _this._recentlyClickedGlobal = (0, lodash_1.cloneDeep)(e.data.global);
            }
            // We can use a debouncer to reset the count when no click occurs for a certain period.
            _this._multiClickTimer();
            // Click callback includes count parameter to record subsequent clicks on the same point
            if (_this.mouseInteractions && _this.mouseInteractions.click) {
                _this.mouseInteractions.click(el, e, _this._mouseClicks);
            }
        }).bind(this));
        el.displayObject.on('mouseover', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseover) {
                _this.mouseInteractions.mouseover(el, e);
            }
        }).bind(this));
        el.displayObject.on('mouseout', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseout) {
                _this.mouseInteractions.mouseout(el, e);
            }
        }).bind(this));
        el.displayObject.on('mousedown', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mousedown) {
                _this.mouseInteractions.mousedown(el, e);
            }
        }).bind(this));
        el.displayObject.on('mouseup', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseup) {
                _this.mouseInteractions.mouseup(el, e);
            }
        }).bind(this));
    };
    TimeGraphChart.prototype.addRows = function (rows, height) {
        var _this = this;
        if (!this.stateController) {
            throw ('Add this TimeGraphChart to a container before adding rows.');
        }
        this.rowComponents = new Map();
        this.rowStateComponents = new Map();
        this.rowAnnotationComponents = new Map();
        this.rowController.rowHeight = height;
        rows.forEach(function (row, index) {
            _this.addRow(row, height, index);
        });
    };
    TimeGraphChart.prototype.setRowModel = function (rows) {
        this.rows = rows;
    };
    TimeGraphChart.prototype.updateElementStyle = function (model) {
        var style = this.providers.stateStyleProvider && this.providers.stateStyleProvider(model);
        var component = this.rowStateComponents.get(model);
        component && style && (component.style = style);
    };
    TimeGraphChart.prototype.updateRowStyle = function (model) {
        var style = this.providers.rowStyleProvider && this.providers.rowStyleProvider(model);
        var component = this.rowComponents.get(model);
        component && style && (component.style = style);
    };
    TimeGraphChart.prototype.registerMouseInteractions = function (interactions) {
        this.mouseInteractions = interactions;
    };
    TimeGraphChart.prototype.onSelectedStateChanged = function (handler) {
        this.selectedElementChangedHandler.push(handler);
    };
    TimeGraphChart.prototype.getRowModels = function () {
        return this.rows;
    };
    TimeGraphChart.prototype.getElementById = function (id) {
        var element = this.children.find(function (child) {
            return child.id === id;
        });
        return element;
    };
    TimeGraphChart.prototype.selectRow = function (row) {
        if (this.rowController.selectedRow) {
            delete this.rowController.selectedRow.selected;
            this.updateRowStyle(this.rowController.selectedRow);
        }
        this.rowController.selectedRow = row;
        row.selected = true;
        this.updateRowStyle(row);
    };
    TimeGraphChart.prototype.getSelectedState = function () {
        return this.selectedStateModel;
    };
    TimeGraphChart.prototype.selectState = function (model) {
        if (this.selectedStateModel) {
            delete this.selectedStateModel.selected;
            this.updateElementStyle(this.selectedStateModel);
        }
        if (model) {
            var el = this.getElementById(model.id);
            if (el) {
                var row = el.row;
                if (row) {
                    this.selectedStateModel = el.model;
                    el.model.selected = true;
                    this.updateElementStyle(this.selectedStateModel);
                    this.selectRow(row.model);
                }
            }
        }
        else {
            this.selectedStateModel = undefined;
        }
        this.handleSelectedStateChange();
    };
    TimeGraphChart.prototype.setNavigationFlag = function (flag) {
        this.isNavigating = flag;
    };
    TimeGraphChart.prototype.selectStateInNavigation = function () {
        var row = this.rowController.selectedRow;
        if (row && this.unitController.selectionRange) {
            var cursorPosition_1 = this.unitController.selectionRange.end;
            var state = row.states.find(function (stateModel) { return stateModel.range.start === cursorPosition_1 || stateModel.range.end === cursorPosition_1; });
            this.selectState(state);
        }
        this.setNavigationFlag(false);
    };
    return TimeGraphChart;
}(time_graph_chart_layer_1.TimeGraphChartLayer));
exports.TimeGraphChart = TimeGraphChart;
//# sourceMappingURL=time-graph-chart.js.map