"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageManager = exports.MessageSeverity = exports.MessageCategory = void 0;
var MessageCategory;
(function (MessageCategory) {
    MessageCategory[MessageCategory["TRACE_CONTEXT"] = 0] = "TRACE_CONTEXT";
    MessageCategory[MessageCategory["SERVER_MESSAGE"] = 1] = "SERVER_MESSAGE";
    MessageCategory[MessageCategory["SERVER_STATUS"] = 2] = "SERVER_STATUS";
})(MessageCategory = exports.MessageCategory || (exports.MessageCategory = {}));
var MessageSeverity;
(function (MessageSeverity) {
    MessageSeverity[MessageSeverity["ERROR"] = 0] = "ERROR";
    MessageSeverity[MessageSeverity["WARNING"] = 1] = "WARNING";
    MessageSeverity[MessageSeverity["INFO"] = 2] = "INFO";
    MessageSeverity[MessageSeverity["DEBUG"] = 3] = "DEBUG";
})(MessageSeverity = exports.MessageSeverity || (exports.MessageSeverity = {}));
class MessageManager {
    addStatusMessage(messageKey, { text, category = MessageCategory.SERVER_MESSAGE, severity = MessageSeverity.INFO }) {
        console.log('New status message', messageKey, text, category, severity);
    }
    removeStatusMessage(messageKey) {
        console.log('Removing status message status message', messageKey);
    }
}
exports.MessageManager = MessageManager;
//# sourceMappingURL=message-manager.js.map