"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalDebugSessionOptions = exports.DebugSessionOptions = exports.DebugCompoundRoot = void 0;
const core_1 = require("@theia/core");
class DebugCompoundRoot {
    constructor() {
        this.stopped = false;
        this.stopEmitter = new core_1.Emitter();
        this.onDidSessionStop = this.stopEmitter.event;
    }
    stopSession() {
        if (!this.stopped) { // avoid sending extraneous terminate events
            this.stopped = true;
            this.stopEmitter.fire();
        }
    }
}
exports.DebugCompoundRoot = DebugCompoundRoot;
var DebugSessionOptions;
(function (DebugSessionOptions) {
    function isConfiguration(options) {
        return !!options && 'configuration' in options && !!options.configuration;
    }
    DebugSessionOptions.isConfiguration = isConfiguration;
    function isDynamic(options) {
        return isConfiguration(options) && 'providerType' in options && !!options.providerType;
    }
    DebugSessionOptions.isDynamic = isDynamic;
    function isCompound(options) {
        return !!options && 'compound' in options && !!options.compound;
    }
    DebugSessionOptions.isCompound = isCompound;
})(DebugSessionOptions = exports.DebugSessionOptions || (exports.DebugSessionOptions = {}));
var InternalDebugSessionOptions;
(function (InternalDebugSessionOptions) {
    const SEPARATOR = '__CONF__';
    const SEPARATOR_CONFIGS = '__COMP__';
    function is(options) {
        return 'id' in options;
    }
    InternalDebugSessionOptions.is = is;
    /** @deprecated Please use `JSON.stringify` to serialize the options. */
    function toValue(options) {
        var _a;
        if (DebugSessionOptions.isCompound(options)) {
            return options.compound.name + SEPARATOR +
                options.workspaceFolderUri + SEPARATOR +
                ((_a = options.compound) === null || _a === void 0 ? void 0 : _a.configurations.join(SEPARATOR_CONFIGS));
        }
        return options.configuration.name + SEPARATOR +
            options.configuration.type + SEPARATOR +
            options.configuration.request + SEPARATOR +
            options.workspaceFolderUri + SEPARATOR +
            options.providerType;
    }
    InternalDebugSessionOptions.toValue = toValue;
    /** @deprecated Please use `JSON.parse` to restore previously serialized debug session options. */
    // eslint-disable-next-line deprecation/deprecation
    function parseValue(value) {
        const split = value.split(SEPARATOR);
        if (split.length === 5) {
            return { name: split[0], type: split[1], request: split[2], workspaceFolderUri: split[3], providerType: split[4] };
        }
        if (split.length === 3) {
            return { name: split[0], workspaceFolderUri: split[1], configurations: split[2].split(SEPARATOR_CONFIGS) };
        }
        throw new Error('Unexpected argument, the argument is expected to have been generated by the \'toValue\' function');
    }
    InternalDebugSessionOptions.parseValue = parseValue;
})(InternalDebugSessionOptions = exports.InternalDebugSessionOptions || (exports.InternalDebugSessionOptions = {}));
//# sourceMappingURL=debug-session-options.js.map