"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuickInputEditorWidget = exports.QuickInputEditorContribution = exports.StandaloneQuickInputService = exports.EditorScopedQuickInputService = void 0;
require("./standaloneQuickInput.css");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const themeService_1 = require("../../../../platform/theme/common/themeService");
const cancellation_1 = require("../../../../base/common/cancellation");
const instantiation_1 = require("../../../../platform/instantiation/common/instantiation");
const contextkey_1 = require("../../../../platform/contextkey/common/contextkey");
const accessibility_1 = require("../../../../platform/accessibility/common/accessibility");
const standaloneLayoutService_1 = require("../standaloneLayoutService");
const codeEditorService_1 = require("../../../browser/services/codeEditorService");
const quickInput_1 = require("../../../../platform/quickinput/browser/quickInput");
const functional_1 = require("../../../../base/common/functional");
let EditorScopedQuickInputService = class EditorScopedQuickInputService extends quickInput_1.QuickInputService {
    constructor(editor, instantiationService, contextKeyService, themeService, accessibilityService, codeEditorService) {
        super(instantiationService, contextKeyService, themeService, accessibilityService, new standaloneLayoutService_1.EditorScopedLayoutService(editor.getContainerDomNode(), codeEditorService));
        this.host = undefined;
        // Use the passed in code editor as host for the quick input widget
        const contribution = QuickInputEditorContribution.get(editor);
        if (contribution) {
            const widget = contribution.widget;
            this.host = {
                _serviceBrand: undefined,
                get hasContainer() { return true; },
                get container() { return widget.getDomNode(); },
                get dimension() { return editor.getLayoutInfo(); },
                get onDidLayout() { return editor.onDidLayoutChange; },
                focus: () => editor.focus()
            };
        }
        else {
            this.host = undefined;
        }
    }
    createController() {
        return super.createController(this.host);
    }
};
EditorScopedQuickInputService = __decorate([
    __param(1, instantiation_1.IInstantiationService),
    __param(2, contextkey_1.IContextKeyService),
    __param(3, themeService_1.IThemeService),
    __param(4, accessibility_1.IAccessibilityService),
    __param(5, codeEditorService_1.ICodeEditorService)
], EditorScopedQuickInputService);
exports.EditorScopedQuickInputService = EditorScopedQuickInputService;
let StandaloneQuickInputService = class StandaloneQuickInputService {
    constructor(instantiationService, codeEditorService) {
        this.instantiationService = instantiationService;
        this.codeEditorService = codeEditorService;
        this.mapEditorToService = new Map();
    }
    get activeService() {
        const editor = this.codeEditorService.getFocusedCodeEditor();
        if (!editor) {
            throw new Error('Quick input service needs a focused editor to work.');
        }
        // Find the quick input implementation for the focused
        // editor or create it lazily if not yet created
        let quickInputService = this.mapEditorToService.get(editor);
        if (!quickInputService) {
            const newQuickInputService = quickInputService = this.instantiationService.createInstance(EditorScopedQuickInputService, editor);
            this.mapEditorToService.set(editor, quickInputService);
            (0, functional_1.once)(editor.onDidDispose)(() => {
                newQuickInputService.dispose();
                this.mapEditorToService.delete(editor);
            });
        }
        return quickInputService;
    }
    get quickAccess() { return this.activeService.quickAccess; }
    get backButton() { return this.activeService.backButton; }
    get onShow() { return this.activeService.onShow; }
    get onHide() { return this.activeService.onHide; }
    pick(picks, options = {}, token = cancellation_1.CancellationToken.None) {
        return this.activeService /* TS fail */.pick(picks, options, token);
    }
    input(options, token) {
        return this.activeService.input(options, token);
    }
    createQuickPick() {
        return this.activeService.createQuickPick();
    }
    createInputBox() {
        return this.activeService.createInputBox();
    }
    focus() {
        return this.activeService.focus();
    }
    toggle() {
        return this.activeService.toggle();
    }
    navigate(next, quickNavigate) {
        return this.activeService.navigate(next, quickNavigate);
    }
    accept() {
        return this.activeService.accept();
    }
    back() {
        return this.activeService.back();
    }
    cancel() {
        return this.activeService.cancel();
    }
};
StandaloneQuickInputService = __decorate([
    __param(0, instantiation_1.IInstantiationService),
    __param(1, codeEditorService_1.ICodeEditorService)
], StandaloneQuickInputService);
exports.StandaloneQuickInputService = StandaloneQuickInputService;
class QuickInputEditorContribution {
    constructor(editor) {
        this.editor = editor;
        this.widget = new QuickInputEditorWidget(this.editor);
    }
    static get(editor) {
        return editor.getContribution(QuickInputEditorContribution.ID);
    }
    dispose() {
        this.widget.dispose();
    }
}
exports.QuickInputEditorContribution = QuickInputEditorContribution;
QuickInputEditorContribution.ID = 'editor.controller.quickInput';
class QuickInputEditorWidget {
    constructor(codeEditor) {
        this.codeEditor = codeEditor;
        this.domNode = document.createElement('div');
        this.codeEditor.addOverlayWidget(this);
    }
    getId() {
        return QuickInputEditorWidget.ID;
    }
    getDomNode() {
        return this.domNode;
    }
    getPosition() {
        return { preference: 2 /* OverlayWidgetPositionPreference.TOP_CENTER */ };
    }
    dispose() {
        this.codeEditor.removeOverlayWidget(this);
    }
}
exports.QuickInputEditorWidget = QuickInputEditorWidget;
QuickInputEditorWidget.ID = 'editor.contrib.quickInputWidget';
(0, editorExtensions_1.registerEditorContribution)(QuickInputEditorContribution.ID, QuickInputEditorContribution);
//# sourceMappingURL=standaloneQuickInputService.js.map