"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.IWorkspaceTrustRequestService = exports.IWorkspaceTrustManagementService = exports.IWorkspaceTrustEnablementService = exports.workspaceTrustToString = exports.WorkspaceTrustScope = void 0;
const nls_1 = require("../../../nls");
const instantiation_1 = require("../../instantiation/common/instantiation");
var WorkspaceTrustScope;
(function (WorkspaceTrustScope) {
    WorkspaceTrustScope[WorkspaceTrustScope["Local"] = 0] = "Local";
    WorkspaceTrustScope[WorkspaceTrustScope["Remote"] = 1] = "Remote";
})(WorkspaceTrustScope = exports.WorkspaceTrustScope || (exports.WorkspaceTrustScope = {}));
function workspaceTrustToString(trustState) {
    if (trustState) {
        return (0, nls_1.localize)('trusted', "Trusted");
    }
    else {
        return (0, nls_1.localize)('untrusted', "Restricted Mode");
    }
}
exports.workspaceTrustToString = workspaceTrustToString;
exports.IWorkspaceTrustEnablementService = (0, instantiation_1.createDecorator)('workspaceTrustEnablementService');
exports.IWorkspaceTrustManagementService = (0, instantiation_1.createDecorator)('workspaceTrustManagementService');
exports.IWorkspaceTrustRequestService = (0, instantiation_1.createDecorator)('workspaceTrustRequestService');
//# sourceMappingURL=workspaceTrust.js.map